/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.IRendererWithModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEntity;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ObsidilithArmorRenderer
implements IRendererWithModel,
IRenderer<ObsidilithEntity> {
    private final GeoModel<ObsidilithEntity> geoModel;
    private final EntityRendererProvider.Context context;
    private final ResourceLocation armorTexture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/obsidilith_armor.png");
    private RenderHelper geoModelProvider;
    private ObsidilithEntity obsidilithEntity;
    private RenderType type;

    public ObsidilithArmorRenderer(GeoModel<ObsidilithEntity> geoModel, EntityRendererProvider.Context context) {
        this.geoModel = geoModel;
        this.context = context;
    }

    @Override
    public void render(ObsidilithEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        float renderAge = (float)entity.tickCount + partialTicks;
        float textureOffset = renderAge * new Random().nextFloat();
        if (this.geoModelProvider == null) {
            this.geoModelProvider = new RenderHelper(entity, this.geoModel, this.context);
        }
        this.obsidilithEntity = entity;
        this.type = RenderType.energySwirl((ResourceLocation)this.armorTexture, (float)textureOffset, (float)textureOffset);
    }

    @Override
    public void render(BakedGeoModel model, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        VertexConsumer energyBuffer = buffer.getBuffer(this.type);
        if (this.obsidilithEntity == null) {
            return;
        }
        if (this.type == null) {
            return;
        }
        if (this.obsidilithEntity.isShielded()) {
            Vec3 color = this.getColor().add(VecUtils.unit).normalize().scale(0.6);
            int colour = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)((float)color.x), (float)((float)color.y), (float)((float)color.z));
            if (this.geoModelProvider == null) {
                return;
            }
            this.geoModelProvider.actuallyRender(poseStack, (Entity)this.obsidilithEntity, model, this.type, buffer, energyBuffer, false, partialTicks, packedLightIn, OverlayTexture.NO_OVERLAY, colour);
        }
    }

    private Vec3 getColor() {
        return switch (this.obsidilithEntity.currentAttack) {
            case 5 -> Vec3Colors.ORANGE;
            case 6 -> Vec3Colors.RED;
            case 7 -> Vec3Colors.COMET_BLUE;
            case 8 -> Vec3Colors.ENDER_PURPLE;
            case 9 -> Vec3Colors.WHITE;
            default -> Vec3Colors.WHITE;
        };
    }

    private static class RenderHelper
    extends GeoEntityRenderer<ObsidilithEntity> {
        private final ObsidilithEntity entity;

        public RenderHelper(ObsidilithEntity entity, GeoModel<ObsidilithEntity> parentModel, EntityRendererProvider.Context context) {
            super(context, parentModel);
            this.entity = entity;
        }

        public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
            poseStack.pushPose();
            poseStack.scale(1.08f, 1.05f, 1.08f);
            super.renderCube(poseStack, cube, buffer, 0xF000F0, packedOverlay, colour);
            poseStack.popPose();
        }

        public ObsidilithEntity getAnimatable() {
            return this.entity;
        }
    }
}

