/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.entity.IGunOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientMessagePlayerShoot
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientMessagePlayerShoot> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"client_player_shoot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientMessagePlayerShoot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, message -> message.timestamp, ClientMessagePlayerShoot::new);
    private final long timestamp;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientMessagePlayerShoot(long timestamp) {
        this.timestamp = timestamp;
    }

    public static void handle(ClientMessagePlayerShoot message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer entity = (ServerPlayer)context.player();
            IGunOperator.fromLivingEntity((LivingEntity)entity).shoot(() -> ((ServerPlayer)entity).getXRot(), () -> ((ServerPlayer)entity).getYRot(), message.timestamp);
        });
    }
}

