/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.inventory;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageCraft;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonBlockIndex;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.IContainerFactory;

public class GunSmithTableMenu
extends AbstractContainerMenu {
    public static final MenuType<GunSmithTableMenu> TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(id, inventory, buf) -> {
        ResourceLocation resourceLocation = null;
        if (buf != null) {
            resourceLocation = buf.readResourceLocation();
        }
        return new GunSmithTableMenu(id, inventory, resourceLocation);
    }), FeatureFlags.DEFAULT_FLAGS);
    private final ResourceLocation blockId;
    private final RecipeFilter filter;

    public GunSmithTableMenu(int id, Inventory inventory, @Nullable ResourceLocation resourceLocation) {
        super(TYPE, id);
        this.blockId = resourceLocation;
        this.filter = TimelessAPI.getCommonBlockIndex(this.getBlockId()).map(CommonBlockIndex::getFilter).orElse(null);
    }

    @Nullable
    public ResourceLocation getBlockId() {
        return this.blockId;
    }

    public ItemStack quickMoveStack(Player player, int pIndex) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }

    @Nullable
    private GunSmithTableRecipe getRecipe(ResourceLocation recipeId, RecipeManager recipeManager) {
        Recipe recipe;
        if (!(DefaultAssets.DEFAULT_BLOCK_ID.equals((Object)this.getBlockId()) && !((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue() || this.filter == null || this.filter.contains(recipeId))) {
            return null;
        }
        RecipeHolder holder = recipeManager.byKey(recipeId).orElse(null);
        if (holder != null && (recipe = holder.value()) instanceof GunSmithTableRecipe) {
            GunSmithTableRecipe gunSmithTableRecipe = (GunSmithTableRecipe)recipe;
            boolean flag = TimelessAPI.getCommonBlockIndex(this.getBlockId()).map(blockIndex -> blockIndex.getData().getTabs().stream().noneMatch(tab -> tab.id().equals((Object)gunSmithTableRecipe.getTab()))).orElse(true);
            if (DefaultAssets.DEFAULT_BLOCK_ID.equals((Object)this.getBlockId()) && !((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue()) {
                flag = false;
            }
            if (flag) {
                return null;
            }
            return gunSmithTableRecipe;
        }
        return null;
    }

    public void doCraft(ResourceLocation recipeId, Player player) {
        GunSmithTableRecipe recipe = this.getRecipe(recipeId, player.level().getRecipeManager());
        if (recipe == null) {
            return;
        }
        Optional.ofNullable((IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY, null)).ifPresent(handler -> {
            if (!player.isCreative()) {
                Int2IntArrayMap recordCount = new Int2IntArrayMap();
                List<GunSmithTableIngredient> ingredients = recipe.getInputs();
                for (GunSmithTableIngredient ingredient : ingredients) {
                    int count = 0;
                    for (int slotIndex = 0; slotIndex < handler.getSlots(); ++slotIndex) {
                        ItemStack stack = handler.getStackInSlot(slotIndex);
                        int stackCount = stack.getCount();
                        if (stack.isEmpty() || !ingredient.getIngredient().test(stack)) continue;
                        if ((count += stackCount) <= ingredient.getCount()) {
                            recordCount.put(slotIndex, stackCount);
                            continue;
                        }
                        int remaining = count - ingredient.getCount();
                        recordCount.put(slotIndex, stackCount - remaining);
                        break;
                    }
                    if (count >= ingredient.getCount()) continue;
                    return;
                }
                IntIterator intIterator = recordCount.keySet().iterator();
                while (intIterator.hasNext()) {
                    int slotIndex = (Integer)intIterator.next();
                    handler.extractItem(slotIndex, recordCount.get(slotIndex), false);
                }
            }
            Level level = player.level();
            if (!level.isClientSide) {
                ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), recipe.getResultItem((HolderLookup.Provider)player.registryAccess()).copy());
                itemEntity.setPickUpDelay(0);
                level.addFreshEntity((Entity)itemEntity);
            }
            player.inventoryMenu.broadcastFullState();
            NetworkHandler.sendToClientPlayer(new ServerMessageCraft(this.containerId), player);
        });
    }
}

