/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.item.GunTooltipPart;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class HideTooltipPartCommand {
    private static final String HIDE_TOOLTIP_PART_NAME = "hide_tooltip_part";
    private static final String ENTITY = "target";
    private static final String MASK = "mask";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder base = Commands.literal((String)HIDE_TOOLTIP_PART_NAME);
        RequiredArgumentBuilder entities = Commands.argument((String)ENTITY, (ArgumentType)EntityArgument.entities());
        RequiredArgumentBuilder part = Commands.argument((String)MASK, (ArgumentType)IntegerArgumentType.integer((int)0));
        base.then(entities.then(part.executes(HideTooltipPartCommand::setHide)));
        return base;
    }

    private static int setHide(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(context, (String)ENTITY);
        int cnt = 0;
        int mask = IntegerArgumentType.getInteger(context, (String)MASK);
        for (Entity entity : entities) {
            LivingEntity living;
            ItemStack stack;
            if (!(entity instanceof LivingEntity) || !((stack = (living = (LivingEntity)entity).getMainHandItem()).getItem() instanceof IGun)) continue;
            GunTooltipPart.setHideFlags(stack, mask);
            ++cnt;
        }
        return cnt;
    }
}

