/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.util.RenderDistance;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AttachmentItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static AttachmentItemRenderer INSTANCE;
    public static final SlotModel SLOT_ATTACHMENT_MODEL;

    public AttachmentItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Item item = stack.getItem();
        if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            ResourceLocation attachmentId = iAttachment.getAttachmentId(stack);
            poseStack.pushPose();
            TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresentOrElse(attachmentIndex -> {
                if (transformType == ItemDisplayContext.GUI) {
                    poseStack.translate(0.5, 1.5, 0.5);
                    poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
                    VertexConsumer buffer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)attachmentIndex.getSlotTexture()));
                    SLOT_ATTACHMENT_MODEL.renderToBuffer(poseStack, buffer, pPackedLight, pPackedOverlay);
                    return;
                }
                poseStack.translate(0.5, 2.0, 0.5);
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                if (transformType == ItemDisplayContext.FIXED) {
                    poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                }
                this.renderDefaultAttachment(transformType, poseStack, pBuffer, pPackedLight, pPackedOverlay, (ClientAttachmentIndex)attachmentIndex);
            }, () -> {
                poseStack.translate(0.5, 1.5, 0.5);
                poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
                VertexConsumer buffer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)MissingTextureAtlasSprite.getLocation()));
                SLOT_ATTACHMENT_MODEL.renderToBuffer(poseStack, buffer, pPackedLight, pPackedOverlay);
            });
            poseStack.popPose();
        }
    }

    private void renderDefaultAttachment(@NotNull ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, ClientAttachmentIndex attachmentIndex) {
        BedrockAttachmentModel model = attachmentIndex.getAttachmentModel();
        ResourceLocation texture = attachmentIndex.getModelTexture();
        if (model != null && texture != null) {
            Pair<BedrockAttachmentModel, ResourceLocation> lodModel = attachmentIndex.getLodModel();
            if (lodModel != null && !RenderDistance.inRenderHighPolyModelDistance(poseStack) && !transformType.firstPerson()) {
                model = (BedrockAttachmentModel)lodModel.getLeft();
                texture = (ResourceLocation)lodModel.getRight();
            }
            RenderType renderType = RenderType.entityCutout((ResourceLocation)texture);
            model.render(null, null, poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
        } else {
            poseStack.translate(0.0, 0.5, 0.0);
            if (transformType == ItemDisplayContext.FIXED) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            VertexConsumer buffer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)attachmentIndex.getSlotTexture()));
            SLOT_ATTACHMENT_MODEL.renderToBuffer(poseStack, buffer, pPackedLight, pPackedOverlay);
        }
    }

    static {
        SLOT_ATTACHMENT_MODEL = new SlotModel();
    }
}

