/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class GunPropertyDiagrams {
    public static int getHidePropertyButtonYOffset() {
        int[] startYOffset = new int[]{49};
        AttachmentPropertyManager.getModifiers().forEach((key, value) -> {
            startYOffset[0] = startYOffset[0] + value.getDiagramsDataSize() * 10;
        });
        return startYOffset[0];
    }

    public static void draw(GuiGraphics graphics, Font font, int x, int y) {
        graphics.fill(x, y, x + 288, y + GunPropertyDiagrams.getHidePropertyButtonYOffset() - 11, -1356717534);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack gunItem = player.getMainHandItem();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((LivingEntity)player).getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            GunData gunData = index.getGunData();
            FireMode fireMode = iGun.getFireMode(gunItem);
            int barStartX = x + 83;
            int barMaxWidth = 120;
            int barEndX = barStartX + barMaxWidth;
            int barBackgroundColor = -16777216;
            int barBaseColor = -1;
            int barPositivelyColor = -11141291;
            int barNegativeColor = -43691;
            int fontColor = 0xCCCCCC;
            int nameTextStartX = x + 5;
            int valueTextStartX = x + 210;
            int[] yOffset = new int[]{y + 5};
            MutableComponent fireModeText = Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.fire_mode");
            if (fireMode == FireMode.AUTO) {
                fireModeText.append((Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.auto"));
            } else if (fireMode == FireMode.SEMI) {
                fireModeText.append((Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.semi"));
            } else if (fireMode == FireMode.BURST) {
                fireModeText.append((Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.burst"));
            } else {
                fireModeText.append((Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.unknown"));
            }
            graphics.drawString(font, (Component)fireModeText, nameTextStartX + 12, yOffset[0], fontColor, false);
            yOffset[0] = yOffset[0] + 10;
            if (iGun.useInventoryAmmo(gunItem)) {
                graphics.drawString(font, (Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.ammo_capacity"), nameTextStartX, yOffset[0], fontColor, false);
                graphics.fill(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.fill(barStartX, yOffset[0] + 2, barStartX + barMaxWidth, yOffset[0] + 6, barBaseColor);
                graphics.drawString(font, (Component)Component.literal((String)"INV"), valueTextStartX, yOffset[0], fontColor, false);
            } else {
                int barrelBulletAmount = iGun.hasBulletInBarrel(gunItem) && index.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
                int ammoAmount = gunData.getAmmoAmount() + barrelBulletAmount;
                double ammoAmountPercent = Math.min((double)ammoAmount / 100.0, 1.0);
                int ammoLength = (int)((double)barStartX + (double)barMaxWidth * ammoAmountPercent);
                int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData()) + barrelBulletAmount;
                int addAmmoCount = Math.max(maxAmmoCount - ammoAmount, 0);
                int addAmmoCountLength = (int)((double)(barMaxWidth * addAmmoCount) / 100.0);
                graphics.drawString(font, (Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.ammo_capacity"), nameTextStartX, yOffset[0], fontColor, false);
                graphics.fill(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.fill(barStartX, yOffset[0] + 2, ammoLength, yOffset[0] + 6, barBaseColor);
                if (addAmmoCount > 0) {
                    int barRight = Math.min(ammoLength + addAmmoCountLength, barEndX);
                    graphics.fill(ammoLength, yOffset[0] + 2, barRight, yOffset[0] + 6, barPositivelyColor);
                    graphics.drawString(font, String.format("%d \u00a7a(+%d)", ammoAmount, addAmmoCount), valueTextStartX, yOffset[0], fontColor, false);
                } else {
                    graphics.drawString(font, String.format("%d", ammoAmount), valueTextStartX, yOffset[0], fontColor, false);
                }
            }
            yOffset[0] = yOffset[0] + 10;
            float sprintTime = gunData.getSprintTime();
            double sprintTimePercent = Mth.clamp((double)((double)sprintTime / 0.5), (double)0.0, (double)1.0);
            int sprintLength = (int)((double)barStartX + (double)barMaxWidth * sprintTimePercent);
            String sprintValueText = String.format("%.2fs", Float.valueOf(sprintTime));
            graphics.drawString(font, (Component)Component.translatable((String)"gui.tacz.gun_refit.property_diagrams.sprint_time"), nameTextStartX, yOffset[0], fontColor, false);
            graphics.fill(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
            graphics.fill(barStartX, yOffset[0] + 2, sprintLength, yOffset[0] + 6, barBaseColor);
            graphics.drawString(font, sprintValueText, valueTextStartX, yOffset[0], fontColor, false);
            yOffset[0] = yOffset[0] + 10;
            AttachmentPropertyManager.getModifiers().forEach((key, value) -> value.getPropertyDiagramsData(gunItem, gunData, cacheProperty).forEach(data -> {
                double defaultPercent = data.defaultPercent();
                double modifierPercent = data.modifierPercent();
                double modifier = data.modifier().doubleValue();
                String titleKey = data.titleKey();
                String positivelyString = data.positivelyString();
                String negativeString = data.negativeString();
                String defaultString = data.defaultString();
                boolean positivelyBetter = data.positivelyBetter();
                defaultPercent = Mth.clamp((double)defaultPercent, (double)0.0, (double)1.0);
                int defaultLength = (int)((double)barStartX + (double)barMaxWidth * defaultPercent);
                int modifierLength = Mth.clamp((int)(defaultLength + (int)((double)barMaxWidth * modifierPercent)), (int)barStartX, (int)barEndX);
                graphics.drawString(font, (Component)Component.translatable((String)titleKey), nameTextStartX, yOffset[0], fontColor, false);
                graphics.fill(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.fill(barStartX, yOffset[0] + 2, defaultLength, yOffset[0] + 6, barBaseColor);
                if (modifier > 0.0) {
                    int barColor = positivelyBetter ? barPositivelyColor : barNegativeColor;
                    graphics.fill(defaultLength, yOffset[0] + 2, modifierLength, yOffset[0] + 6, barColor);
                    graphics.drawString(font, positivelyString, valueTextStartX, yOffset[0], fontColor, false);
                } else if (modifier < 0.0) {
                    int barColor = positivelyBetter ? barNegativeColor : barPositivelyColor;
                    graphics.fill(modifierLength, yOffset[0] + 2, defaultLength, yOffset[0] + 6, barColor);
                    graphics.drawString(font, negativeString, valueTextStartX, yOffset[0], fontColor, false);
                } else {
                    graphics.drawString(font, defaultString, valueTextStartX, yOffset[0], fontColor, false);
                }
                yOffset[0] = yOffset[0] + 10;
            }));
        });
    }
}

