/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import org.jetbrains.annotations.NotNull;

public class GunPackProgressScreen
extends Screen
implements HttpUtil.DownloadProgressListener {
    @Nullable
    private Component header;
    @Nullable
    private Component stage;
    private int progress;
    private boolean stop;
    private long total;
    private long downloaded;

    public GunPackProgressScreen() {
        super(GameNarrator.NO_TITLE);
    }

    protected void init() {
        Button button = Button.builder((Component)Component.translatable((String)"gui.tacz.client_gun_pack_downloader.background_download"), b -> this.requestFinished(false)).bounds((this.width - 200) / 2, 120, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)button);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        if (this.stop) {
            this.getMinecraft().setScreen(null);
        } else {
            this.renderBackground(gui, mouseX, mouseY, partialTick);
            if (this.header != null) {
                gui.drawCenteredString(this.font, this.header, this.width / 2, 70, 0xFFFFFF);
            }
            if (this.stage != null && this.progress > 0) {
                MutableComponent text = this.stage.copy().append(" " + this.progress + "%");
                gui.drawCenteredString(this.font, (Component)text, this.width / 2, 90, 0xFFFFFF);
            }
            super.render(gui, mouseX, mouseY, partialTick);
        }
    }

    public void requestStart() {
        this.header = Component.translatable((String)"gui.tacz.client_gun_pack_downloader.downloading");
    }

    public void downloadStart(OptionalLong optionalLong) {
        this.total = optionalLong.orElse(0L);
        this.downloaded = 0L;
        this.progress = 0;
    }

    public void downloadedBytes(long l) {
        this.downloaded += l;
        this.progress = (int)Math.ceil((double)this.total / (double)this.downloaded);
    }

    public void requestFinished(boolean b) {
        this.stop = true;
    }
}

