/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.renderer.crosshair.CrosshairType;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.config.client.RenderConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class RenderCrosshairEvent {
    private static final ResourceLocation HIT_ICON = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/crosshair/hit/hit_marker.png");
    private static final long KEEP_TIME = 300L;
    private static boolean isRefitScreen = false;
    private static long hitTimestamp = -1L;
    private static long killTimestamp = -1L;
    private static long headShotTimestamp = -1L;

    public static void onRenderCrosshair(GuiGraphics graphics, Window window, DeltaTracker delta, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!IGun.mainHandHoldGun((LivingEntity)player)) {
            return;
        }
        ci.cancel();
        RenderCrosshairEvent.renderHitMarker(graphics, window);
        ReloadState reloadState = IGunOperator.fromLivingEntity((LivingEntity)player).getSynReloadState();
        if (reloadState.getStateType().isReloading()) {
            return;
        }
        if (isRefitScreen) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof IGun)) {
            return;
        }
        IClientPlayerGunOperator playerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
        TimelessAPI.getGunDisplay(stack).ifPresent(gunIndex -> {
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine;
            Object context;
            if ((double)playerGunOperator.getClientAimingProgress(delta.getGameTimeDeltaPartialTick(false)) > 0.9) {
                boolean forceShow = gunIndex.isShowCrosshair();
                boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
                if (!forceShow && !shoulderSurfingForceShow) {
                    return;
                }
            }
            if ((context = (animationStateMachine = gunIndex.getAnimationStateMachine()).getContext()) == null || !((AnimationStateContext)context).shouldHideCrossHair()) {
                RenderCrosshairEvent.renderCrosshair(graphics, window);
            }
        });
    }

    @SubscribeEvent
    public static void onRenderTick(RenderFrameEvent.Pre event) {
        isRefitScreen = Minecraft.getInstance().screen instanceof GunRefitScreen;
    }

    private static void renderCrosshair(GuiGraphics graphics, Window window) {
        Options options = Minecraft.getInstance().options;
        boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
        if (!options.getCameraType().isFirstPerson() && !shoulderSurfingForceShow) {
            return;
        }
        if (options.hideGui) {
            return;
        }
        MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
        if (gameMode == null) {
            return;
        }
        if (gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        int width = window.getGuiScaledWidth();
        int height = window.getGuiScaledHeight();
        ResourceLocation location = CrosshairType.getTextureLocation((CrosshairType)((Object)RenderConfig.CROSSHAIR_TYPE.get()));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        graphics.blit(location, (int)x, (int)y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static void renderHitMarker(GuiGraphics graphics, Window window) {
        float fadeTime;
        long remainHitTime = System.currentTimeMillis() - hitTimestamp;
        long remainKillTime = System.currentTimeMillis() - killTimestamp;
        long remainHeadShotTime = System.currentTimeMillis() - headShotTimestamp;
        float offset = ((Double)RenderConfig.HIT_MARKET_START_POSITION.get()).floatValue();
        if (remainKillTime > 300L) {
            if (remainHitTime > 300L) {
                return;
            }
            fadeTime = remainHitTime;
        } else {
            offset += (float)remainKillTime * 4.0f / 300.0f;
            fadeTime = remainKillTime;
        }
        int width = window.getGuiScaledWidth();
        int height = window.getGuiScaledHeight();
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (remainHeadShotTime > 300L) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - fadeTime / 300.0f));
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)(1.0f - fadeTime / 300.0f));
        }
        graphics.blit(HIT_ICON, (int)(x - offset), (int)(y - offset), 0.0f, 0.0f, 8, 8, 16, 16);
        graphics.blit(HIT_ICON, (int)(x + 8.0f + offset), (int)(y - offset), 8.0f, 0.0f, 8, 8, 16, 16);
        graphics.blit(HIT_ICON, (int)(x - offset), (int)(y + 8.0f + offset), 0.0f, 8.0f, 8, 8, 16, 16);
        graphics.blit(HIT_ICON, (int)(x + 8.0f + offset), (int)(y + 8.0f + offset), 8.0f, 8.0f, 8, 8, 16, 16);
    }

    public static void markHitTimestamp() {
        hitTimestamp = System.currentTimeMillis();
    }

    public static void markKillTimestamp() {
        killTimestamp = System.currentTimeMillis();
    }

    public static void markHeadShotTimestamp() {
        headShotTimestamp = System.currentTimeMillis();
    }
}

