/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;

public class JoinMultiplayerScreenProcessor
extends ScreenProcessor<JoinMultiplayerScreen> {
    private final Supplier<ServerSelectionList> listSupplier;
    private final Supplier<Button> backButtonSupplier;
    private final Supplier<Button> directConnectButtonSupplier;
    private final Supplier<Button> addServerButtonSupplier;

    public JoinMultiplayerScreenProcessor(JoinMultiplayerScreen screen, Supplier<ServerSelectionList> listSupplier, Supplier<Button> backButtonSupplier, Supplier<Button> directConnectButtonSupplier, Supplier<Button> addServerButtonSupplier) {
        super(screen);
        this.listSupplier = listSupplier;
        this.backButtonSupplier = backButtonSupplier;
        this.directConnectButtonSupplier = directConnectButtonSupplier;
        this.addServerButtonSupplier = addServerButtonSupplier;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        Button addServerButton;
        Button directConnectButton;
        if (((JoinMultiplayerScreen)this.screen).getFocused() != null && ((JoinMultiplayerScreen)this.screen).getFocused() instanceof Button && ControlifyBindings.GUI_BACK.on(controller).guiPressed().get()) {
            ((JoinMultiplayerScreen)this.screen).setFocused((GuiEventListener)this.listSupplier.get());
            return;
        }
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).guiPressed().get() && (directConnectButton = this.directConnectButtonSupplier.get()) != null) {
            JoinMultiplayerScreenProcessor.playClackSound();
            directConnectButton.onPress();
        }
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_2.on(controller).guiPressed().get() && (addServerButton = this.addServerButtonSupplier.get()) != null) {
            JoinMultiplayerScreenProcessor.playClackSound();
            addServerButton.onPress();
        }
        super.handleButtons(controller);
    }

    @Override
    public void onWidgetRebuild() {
        Button backButton = this.backButtonSupplier.get();
        Button directConnectButton = this.directConnectButtonSupplier.get();
        Button addServerButton = this.addServerButtonSupplier.get();
        if (backButton != null) {
            ButtonGuideApi.addGuideToButton(backButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        }
        if (directConnectButton != null) {
            ButtonGuideApi.addGuideToButton(directConnectButton, ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
        }
        if (addServerButton != null) {
            ButtonGuideApi.addGuideToButton(addServerButton, ControlifyBindings.GUI_ABSTRACT_ACTION_2, ButtonGuidePredicate.always());
        }
        super.onWidgetRebuild();
    }
}

