/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.controller.steamdeck.SteamDeckComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.components.FakePositionPlainTextButton;
import dev.isxander.controlify.gui.screen.ControllerConfigScreenFactory;
import dev.isxander.controlify.gui.screen.GlobalSettingsScreenFactory;
import dev.isxander.controlify.mixins.feature.ui.AbstractSelectionListAccessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.ColorUtils;
import dev.isxander.controlify.utils.animation.api.Animatable;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerCarouselScreen
extends Screen
implements ScreenControllerEventListener {
    public static final ResourceLocation CHECKMARK = ResourceLocation.withDefaultNamespace((String)"icon/checkmark");
    public static final ResourceLocation DANGER = ResourceLocation.withDefaultNamespace((String)"icon/unseen_notification");
    private final Screen parent;
    private int footerY;
    private List<CarouselEntry> carouselEntries = null;
    private int carouselIndex;
    private Animatable carouselAnimation = null;
    private final Controlify controlify;
    private final ControllerManager controllerManager;
    private Button globalSettingsButton;
    private Button unbindControllerButton;
    private Button doneButton;
    private Button controllerNotDetectedButton;

    private ControllerCarouselScreen(Screen parent) {
        super((Component)Component.translatable((String)"controlify.gui.carousel.title"));
        this.parent = parent;
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.carouselIndex = this.controlify.getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0);
    }

    public static void openConfigScreen(Screen parent) {
        Minecraft.getInstance().setScreen((Screen)new ControllerCarouselScreen(parent));
    }

    protected void init() {
        this.refreshControllers();
        MutableComponent donateText = Component.translatable((String)"controlify.gui.carousel.donate").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        FakePositionPlainTextButton donateBtn = (FakePositionPlainTextButton)this.addRenderableWidget((GuiEventListener)new FakePositionPlainTextButton((Component)donateText, this.font, 3, 3, btn -> Util.getPlatform().openUri("https://patreon.com/isxander")));
        donateBtn.setFakePosition(new ScreenRectangle(0, this.height, this.width, 1));
        MutableComponent artCreditText = Component.translatable((String)"controlify.gui.carousel.art_credit", (Object[])new Object[]{Component.literal((String)"Andrew Grant")}).withStyle(ChatFormatting.DARK_GRAY);
        FakePositionPlainTextButton artCreditBtn = (FakePositionPlainTextButton)this.addRenderableWidget((GuiEventListener)new FakePositionPlainTextButton((Component)artCreditText, this.font, this.width - this.font.width((FormattedText)artCreditText) - 3, 3, btn -> Util.getPlatform().openUri("https://github.com/Andrew6rant")));
        artCreditBtn.setFakePosition(new ScreenRectangle(0, this.height + 1, this.width, 1));
        GridLayout grid = new GridLayout().columnSpacing(10);
        GridLayout.RowHelper rowHelper = grid.createRowHelper(2);
        this.globalSettingsButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"controlify.gui.global_settings.title"), btn -> this.minecraft.setScreen(GlobalSettingsScreenFactory.createGlobalSettingsScreen(this))).build());
        this.doneButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        grid.visitWidgets(widget -> {
            widget.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)widget);
        });
        grid.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)grid, (int)0, (int)(this.height - 36), (int)this.width, (int)36);
        this.controllerNotDetectedButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controlify.gui.carousel.controller_not_detected_btn"), btn -> Util.getPlatform().openUri("https://docs.isxander.dev/controlify/users/controller-issues#my-controller-is-not-detected")).pos(this.width / 2 - 75, (this.height - 36) / 2 + 10).tooltip(Tooltip.create((Component)Component.translatable((String)"controlify.gui.carousel.controller_not_detected_btn.tooltip"))).build());
        this.controllerNotDetectedButton.visible = this.carouselEntries.isEmpty();
        ButtonGuideApi.addGuideToButton(this.globalSettingsButton, ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
        ButtonGuideApi.addGuideToButton(this.doneButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        this.footerY = Mth.roundToward((int)(this.height - 36 - 2), (int)2);
    }

    public void refreshControllers() {
        ControllerEntity prevSelectedController;
        if (this.carouselEntries != null && !this.carouselEntries.isEmpty()) {
            this.carouselEntries.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
            CarouselEntry prevEntry = this.carouselEntries.get(this.carouselIndex);
            if (prevEntry instanceof ControllerCarouselEntry) {
                ControllerCarouselEntry cce = (ControllerCarouselEntry)prevEntry;
                prevSelectedController = cce.controller;
            } else {
                prevSelectedController = null;
            }
        } else {
            prevSelectedController = null;
        }
        this.carouselEntries = new ArrayList<CarouselEntry>();
        this.controllerManager.getConnectedControllers().stream().map(c -> new ControllerCarouselEntry((ControllerEntity)c, this.width / 3, this.height - 66)).forEach(entry -> this.carouselEntries.add((CarouselEntry)((Object)entry)));
        this.carouselIndex = this.carouselEntries.stream().filter(e -> {
            if (e instanceof ControllerCarouselEntry) {
                ControllerCarouselEntry ce = (ControllerCarouselEntry)((Object)e);
                if (ce.controller == prevSelectedController) return true;
            }
            if (prevSelectedController != null) return false;
            if (!(e instanceof KBMControllerCarouselEntry)) return false;
            return true;
        }).findFirst().map(this.carouselEntries::indexOf).orElse(Controlify.instance().getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0));
        if (!this.carouselEntries.isEmpty()) {
            this.carouselEntries.addFirst(new KBMControllerCarouselEntry(this, this.width / 3, this.height - 66));
            this.carouselEntries.forEach(x$0 -> {
                CarouselEntry cfr_ignored_0 = (CarouselEntry)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.carouselEntries.get((int)this.carouselIndex).overlayColor = 0;
        }
        float offsetX = (float)this.width / 2.0f * (float)(-(this.carouselIndex - 1)) - (float)this.width / 6.0f;
        for (int i = 0; i < this.carouselEntries.size(); ++i) {
            CarouselEntry entry2 = this.carouselEntries.get(i);
            entry2.setX(offsetX + (float)this.width / 2.0f * (float)i);
            entry2.setY(i == this.carouselIndex ? 20.0f : 10.0f);
        }
        if (this.controllerNotDetectedButton != null) {
            this.controllerNotDetectedButton.visible = this.carouselEntries.isEmpty();
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        Blit.tex(graphics, this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR, 0, this.footerY, 0.0f, 0.0f, this.width, 2, 32, 2);
        if (this.carouselEntries.isEmpty()) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"controlify.gui.carousel.no_controllers"), this.width / 2, (this.height - 36) / 2 - 10, -5592406);
        }
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        super.renderBackground(graphics, i, j, f);
        Blit.tex(graphics, this.minecraft.level == null ? AbstractSelectionListAccessor.getMenuListBackground() : AbstractSelectionListAccessor.getInWorldMenuListBackground(), 0, 0, 0.0f, 0.0f, this.width, this.footerY, 32, 32);
    }

    public void focusOnEntry(int index) {
        if (this.carouselAnimation != null && !this.carouselAnimation.isDone()) {
            return;
        }
        int diff = index - this.carouselIndex;
        if (diff == 0) {
            return;
        }
        this.carouselIndex = index;
        Animation animation = Animation.of(10).easing(EasingFunction.EASE_IN_OUT_CUBIC);
        for (CarouselEntry entry : this.carouselEntries) {
            boolean selected = this.carouselEntries.indexOf((Object)entry) == index;
            animation.consumerF(entry::setX, entry.getX(), (float)entry.getX() + (float)(-diff) * ((float)this.width / 2.0f));
            animation.consumerF(entry::setY, entry.getY(), selected ? 20.0 : 10.0);
            animation.consumerF(t -> {
                entry.overlayColor = ColorUtils.lerpARGB(t.floatValue(), entry.overlayColor, selected ? 0 : -1879048192);
            }, 0.0, 1.0);
        }
        this.carouselAnimation = animation.play();
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
            this.globalSettingsButton.onPress();
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private abstract class CarouselEntry
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private int x;
        private int y;
        private final int width;
        private final int height;
        private float translationX;
        private float translationY;
        private final Button useButton;
        @Nullable
        private final Button settingsButton;
        private final ImmutableList<? extends GuiEventListener> children;
        private boolean prevUse;
        private float currentlyUsedPos;
        private Animation currentlyUsedAnimation;
        private int overlayColor = -1879048192;
        private boolean hovered = false;

        private CarouselEntry(int width, int height) {
            this.width = width;
            this.height = height;
            int buttonWidth = this.hasSettingsButton() ? (this.getWidth() - 2) / 2 - 2 : this.getWidth() - 4;
            this.settingsButton = !this.hasSettingsButton() ? null : Button.builder((Component)Component.translatable((String)"controlify.gui.carousel.entry.settings"), this::onSettingsButtonPressed).width(buttonWidth).build();
            this.useButton = Button.builder((Component)Component.translatable((String)"controlify.gui.carousel.entry.use"), this::onUseButtonPressed).width(buttonWidth).build();
            this.children = this.hasSettingsButton() ? ImmutableList.of((Object)this.settingsButton, (Object)this.useButton) : ImmutableList.of((Object)this.useButton);
            this.prevUse = this.isCurrentlyUsed();
            this.currentlyUsedPos = this.prevUse ? 1.0f : 0.0f;
        }

        protected abstract Component getName();

        protected abstract Optional<Component> getNickname();

        protected abstract ResourceLocation getIconSprite();

        protected abstract boolean hasSettingsButton();

        protected abstract void onSettingsButtonPressed(Button var1);

        protected abstract boolean isCurrentlyUsed();

        protected abstract void onUseButtonPressed();

        protected void doExtraRendering(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int n;
            this.hovered = this.isMouseOver(mouseX, mouseY);
            boolean hasNickname = this.getNickname().isPresent();
            graphics.enableScissor(this.x, this.y, this.x + this.width + (this.translationX > 0.0f ? 1 : 0), this.y + this.height + (this.translationY > 0.0f ? 1 : 0));
            CGuiPose pose = CGuiPose.ofPush(graphics);
            pose.translate(this.translationX, this.translationY);
            graphics.renderOutline(this.x, this.y, this.width, this.height, 0x5AFFFFFF);
            this.useButton.render(graphics, mouseX, mouseY, delta);
            if (this.hasSettingsButton()) {
                this.settingsButton.render(graphics, mouseX, mouseY, delta);
            }
            Font font = ControllerCarouselScreen.this.font;
            Component component = this.getName();
            int n2 = this.x + this.width / 2;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            if (hasNickname) {
                Objects.requireNonNull(ControllerCarouselScreen.this.font);
                n = 9 + 1;
            } else {
                n = 0;
            }
            graphics.drawCenteredString(font, component, n2, this.y + this.height - 26 - 9 - n, -1);
            this.getNickname().ifPresent(nickname -> {
                Font font = ControllerCarouselScreen.this.font;
                int n = this.x + this.width / 2;
                Objects.requireNonNull(ControllerCarouselScreen.this.font);
                graphics.drawCenteredString(font, nickname, n, this.y + this.height - 26 - 9, -5592406);
            });
            MutableComponent currentlyInUseText = Component.translatable((String)"controlify.gui.carousel.entry.in_use").withStyle(ChatFormatting.GREEN);
            pose.push();
            pose.translate((float)(17 + ControllerCarouselScreen.this.font.width((FormattedText)currentlyInUseText)) * (this.currentlyUsedPos - 1.0f), 0.0f);
            if (this.currentlyUsedPos > 0.0f) {
                ClientUtils.drawSprite(graphics, CHECKMARK, this.x + 4, this.y + 4, 9, 8);
                graphics.drawString(ControllerCarouselScreen.this.font, (Component)currentlyInUseText, this.x + 17, this.y + 4, -1);
            }
            this.doExtraRendering(graphics, mouseX, mouseY, delta);
            pose.pop();
            int iconWidth = this.width - 6;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            int iconHeight = this.height - 22 - 4 - 9 - 8 - (9 * (hasNickname ? 2 : 1) + 1) - 6;
            int iconSize = Mth.roundToward((int)Math.min(iconHeight, iconWidth), (int)2);
            pose.push();
            float f = (float)this.x + (float)this.width / 2.0f - (float)iconSize / 2.0f;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            pose.translate(f, (float)(this.y + 9 + 12) + (float)iconHeight / 2.0f - (float)iconSize / 2.0f);
            pose.scale((float)iconSize / 64.0f, (float)iconSize / 64.0f);
            ClientUtils.drawSprite(graphics, this.getIconSprite(), 0, 0, 64, 64);
            pose.pop();
            pose.translate(0.0f, 0.0f);
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.overlayColor);
            pose.pop();
            graphics.disableScissor();
            if (this.prevUse != this.isCurrentlyUsed()) {
                if (this.currentlyUsedAnimation != null) {
                    this.currentlyUsedAnimation.skipToEnd();
                }
                this.currentlyUsedAnimation = Animation.of(20).easing(EasingFunction.EASE_OUT_QUINT).consumerF(t -> {
                    this.currentlyUsedPos = t.floatValue();
                }, this.currentlyUsedPos, this.isCurrentlyUsed() ? 1.0 : 0.0).play();
            }
            this.prevUse = this.isCurrentlyUsed();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            int index;
            if (this.isMouseOver(mouseX, mouseY) && (index = ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this)) != ControllerCarouselScreen.this.carouselIndex) {
                if (ControllerCarouselScreen.this.carouselAnimation == null || ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                    ControllerCarouselScreen.this.focusOnEntry(index);
                }
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private void onUseButtonPressed(Button button) {
            this.onUseButtonPressed();
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                ControllerCarouselScreen.this.focusOnEntry(ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this));
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public void setX(float x) {
            this.x = (int)x;
            if (this.hasSettingsButton()) {
                this.settingsButton.setX((int)x + 2);
                this.useButton.setX(this.settingsButton.getX() + this.settingsButton.getWidth() + 2);
            } else {
                this.useButton.setX((int)x + 2);
            }
            this.translationX = x - (float)((int)x);
        }

        public void setY(float y) {
            this.y = (int)y;
            int buttonRowY = (int)y + this.getHeight() - 20 - 2;
            this.useButton.setY(buttonRowY);
            if (this.hasSettingsButton()) {
                this.settingsButton.setY(buttonRowY);
            }
            this.translationY = y - (float)((int)y);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            if (ControllerCarouselScreen.this.carouselAnimation != null && !ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                return null;
            }
            return super.nextFocusPath(event);
        }

        public ScreenRectangle getRectangle() {
            return new ScreenRectangle(this.x, this.y, this.width, this.height);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : (this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
        }

        public void updateNarration(NarrationElementOutput builder) {
            builder.add(NarratedElementType.TITLE, this.getName());
            builder.add(NarratedElementType.USAGE, (Component)Component.literal((String)"Left arrow to go to previous controller, right arrow to go to next controller."));
        }
    }

    private class ControllerCarouselEntry
    extends CarouselEntry {
        private final ControllerEntity controller;
        private final boolean badSteamDeck;

        private ControllerCarouselEntry(ControllerEntity controller, int width, int height) {
            super(width, height);
            this.controller = controller;
            this.badSteamDeck = controller.info().type().isSteamDeck() && controller.getComponent(SteamDeckComponent.ID).isEmpty();
        }

        @Override
        protected Component getName() {
            return Component.literal((String)this.controller.name());
        }

        @Override
        protected Optional<Component> getNickname() {
            GenericControllerConfig config = this.controller.genericConfig().config();
            @Nullable String nickname = config.nickname;
            MutableComponent ogName = null;
            if (nickname != null) {
                config.nickname = null;
                ogName = Component.literal((String)this.controller.name());
                config.nickname = nickname;
            }
            return Optional.ofNullable(ogName);
        }

        @Override
        protected ResourceLocation getIconSprite() {
            return this.controller.info().type().getIconSprite();
        }

        @Override
        protected boolean hasSettingsButton() {
            return true;
        }

        @Override
        protected void onSettingsButtonPressed(Button button) {
            ControllerCarouselScreen.this.minecraft.setScreen(ControllerConfigScreenFactory.generateConfigScreen(ControllerCarouselScreen.this, this.controller));
        }

        @Override
        protected boolean isCurrentlyUsed() {
            return Controlify.instance().getCurrentController().orElse(null) == this.controller;
        }

        @Override
        protected void onUseButtonPressed() {
            Controlify.instance().setCurrentController(this.controller, true);
        }

        @Override
        protected void doExtraRendering(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.badSteamDeck) {
                ClientUtils.drawSprite(graphics, DANGER, this.getX() + 4, this.getY() + 4 + 10, 9, 8);
                graphics.drawString(ControllerCarouselScreen.this.font, (Component)Component.translatable((String)"controlify.steam_deck.no_driver"), this.getX() + 17, this.getY() + 4 + 10, -1);
            }
        }
    }

    private class KBMControllerCarouselEntry
    extends CarouselEntry {
        private KBMControllerCarouselEntry(ControllerCarouselScreen controllerCarouselScreen, int width, int height) {
            super(width, height);
        }

        @Override
        protected Component getName() {
            return Component.translatable((String)"controlify.gui.carousel.entry.keyboard_mouse");
        }

        @Override
        protected Optional<Component> getNickname() {
            return Optional.empty();
        }

        @Override
        protected ResourceLocation getIconSprite() {
            return CUtil.rl("keyboard_mouse");
        }

        @Override
        protected boolean hasSettingsButton() {
            return false;
        }

        @Override
        protected void onSettingsButtonPressed(Button button) {
        }

        @Override
        protected boolean isCurrentlyUsed() {
            return Controlify.instance().getCurrentController().orElse(null) == null;
        }

        @Override
        protected void onUseButtonPressed() {
            Controlify.instance().setCurrentController(null, true);
            Controlify.instance().config().setCurrentControllerUid(null);
        }
    }
}

