/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.layout;

import dev.isxander.controlify.gui.layout.AbstractLayoutComponent;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.commons.lang3.Validate;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class ColumnLayoutComponent<T extends RenderComponent>
extends AbstractLayoutComponent<T> {
    private final int componentPaddingVertical;
    private final int colPaddingLeft;
    private final int colPaddingRight;
    private final int colPaddingTop;
    private final int colPaddingBottom;
    private final ElementPosition elementPosition;

    private ColumnLayoutComponent(Collection<? extends T> elements, int componentPaddingVertical, int colPaddingLeft, int colPaddingRight, int colPaddingTop, int colPaddingBottom, ElementPosition elementPosition) {
        for (RenderComponent element : elements) {
            this.insertTop(element);
        }
        this.componentPaddingVertical = componentPaddingVertical;
        this.colPaddingLeft = colPaddingLeft;
        this.colPaddingRight = colPaddingRight;
        this.colPaddingTop = colPaddingTop;
        this.colPaddingBottom = colPaddingBottom;
        this.elementPosition = elementPosition;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float deltaTime) {
        int width = this.getMaxChildWidth();
        if (width == -1) {
            return;
        }
        int yOffset = 0;
        for (RenderComponent element : this.getChildComponents()) {
            if (!element.isVisible()) continue;
            element.render(graphics, x + this.colPaddingLeft + this.elementPosition.positionFunction.apply(width, element.size().x()), y + this.colPaddingTop + yOffset, deltaTime);
            yOffset += element.size().y() + this.componentPaddingVertical;
        }
    }

    @Override
    public Vector2ic size() {
        return new Vector2i(this.getMaxChildWidth() + this.colPaddingLeft + this.colPaddingRight, this.getSumHeight() + this.colPaddingTop + this.colPaddingBottom);
    }

    private int getSumHeight() {
        return this.getChildComponents().stream().filter(RenderComponent::isVisible).map(RenderComponent::size).mapToInt(size -> size.y() + this.componentPaddingVertical).sum() - this.componentPaddingVertical;
    }

    private int getMaxChildWidth() {
        return this.getChildComponents().stream().filter(RenderComponent::isVisible).map(RenderComponent::size).mapToInt(Vector2ic::x).max().orElse(-1);
    }

    public static <T extends RenderComponent> Builder<T> builder() {
        return new Builder();
    }

    public static enum ElementPosition {
        LEFT((rowWidth, elementWidth) -> 0),
        RIGHT((rowWidth, elementWidth) -> rowWidth - elementWidth),
        MIDDLE((rowWidth, elementWidth) -> rowWidth / 2 - elementWidth / 2);

        public final BiFunction<Integer, Integer, Integer> positionFunction;

        private ElementPosition(BiFunction<Integer, Integer, Integer> positionFunction) {
            this.positionFunction = positionFunction;
        }
    }

    public static class Builder<T extends RenderComponent> {
        private final List<T> elements = new ArrayList<T>();
        private int componentPaddingVertical;
        private int colPaddingLeft;
        private int colPaddingRight;
        private int colPaddingTop;
        private int colPaddingBottom;
        private ElementPosition elementPosition = null;

        public Builder<T> element(T element) {
            this.elements.add(element);
            return this;
        }

        public Builder<T> elements(T ... elements) {
            this.elements.addAll(Arrays.asList(elements));
            return this;
        }

        public Builder<T> elements(Collection<? extends T> elements) {
            this.elements.addAll(elements);
            return this;
        }

        public Builder<T> spacing(int padding) {
            this.componentPaddingVertical = padding;
            return this;
        }

        public Builder<T> colPadding(int left, int right, int top, int bottom) {
            this.colPaddingLeft = left;
            this.colPaddingRight = right;
            this.colPaddingTop = top;
            this.colPaddingBottom = bottom;
            return this;
        }

        public Builder<T> colPadding(int horizontal, int vertical) {
            return this.colPadding(horizontal, horizontal, vertical, vertical);
        }

        public Builder<T> colPadding(int padding) {
            return this.colPadding(padding, padding, padding, padding);
        }

        public Builder<T> elementPosition(ElementPosition elementPosition) {
            this.elementPosition = elementPosition;
            return this;
        }

        public ColumnLayoutComponent<T> build() {
            Validate.notEmpty(this.elements, (String)"No elements were added to the column!", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)this.elementPosition), (String)"Element position cannot be null!", (Object[])new Object[0]);
            return new ColumnLayoutComponent<T>(this.elements, this.componentPaddingVertical, this.colPaddingLeft, this.colPaddingRight, this.colPaddingTop, this.colPaddingBottom, this.elementPosition);
        }
    }
}

