/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.font;

import com.mojang.blaze3d.font.GlyphInfo;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.mixins.feature.font.FontAccessor;
import dev.isxander.controlify.utils.CUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.mutable.MutableInt;

public final class BindingFontHelper {
    public static final ResourceLocation WRAPPER_FONT = CUtil.rl("inputs");
    public static final String PLACEHOLDER_KEY = "controlify.placeholder";
    public static final String PLACEHOLDER_CONTROLLER_ACTIVE_KEY = "controlify.placeholder.controller_active";

    public static Component bindingWithActiveFallback(ResourceLocation binding, Component fallback) {
        return Component.translatableWithFallback((String)PLACEHOLDER_CONTROLLER_ACTIVE_KEY, (String)"%2$s", (Object[])new Object[]{BindingFontHelper.binding(binding), fallback});
    }

    public static Component bindingWithActiveFallback(InputBinding binding, Component fallback) {
        return BindingFontHelper.bindingWithActiveFallback(binding.id(), fallback);
    }

    public static Component bindingWithFallback(ResourceLocation binding, Component fallback) {
        return Component.translatableWithFallback((String)PLACEHOLDER_KEY, (String)"%2$s", (Object[])new Object[]{BindingFontHelper.binding(binding), fallback});
    }

    public static Component bindingWithFallback(InputBinding binding, Component fallback) {
        return BindingFontHelper.bindingWithFallback(binding.id(), fallback);
    }

    public static Component binding(ResourceLocation binding) {
        return Component.keybind((String)binding.toString()).withStyle(style -> style.withFont(CUtil.createResourceFont(WRAPPER_FONT)));
    }

    public static Component binding(InputBinding binding) {
        return BindingFontHelper.binding(binding.id());
    }

    public static int getComponentHeight(Font font, FormattedCharSequence text) {
        MutableInt mutableInt = new MutableInt();
        text.accept((index, style, codePoint) -> {
            mutableInt.setValue(Math.max(mutableInt.intValue(), BindingFontHelper.getHeight(font, codePoint, style)));
            return true;
        });
        return mutableInt.intValue();
    }

    public static int getComponentHeight(Font font, FormattedText text) {
        MutableInt mutableInt = new MutableInt();
        StringDecomposer.iterateFormatted((FormattedText)text, (Style)Style.EMPTY, (index, style, codePoint) -> {
            mutableInt.setValue(Math.max(mutableInt.intValue(), BindingFontHelper.getHeight(font, codePoint, style)));
            return true;
        });
        return mutableInt.intValue();
    }

    private static int getHeight(Font font, int codepoint, Style style) {
        FontSet fontSet = ((FontAccessor)font).invokeGetFontSet(style.getFont());
        GlyphInfo glyphInfo = fontSet.getGlyphInfo(codepoint, false);
        MutableInt f = new MutableInt(0);
        glyphInfo.bake(sheetGlyphInfo -> {
            f.setValue(Mth.ceil((float)((float)sheetGlyphInfo.getPixelHeight() / sheetGlyphInfo.getOversample())));
            return null;
        });
        return f.intValue();
    }
}

