/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings.output;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.KeyMappingHandle;
import dev.isxander.controlify.bindings.StateAccess;
import dev.isxander.controlify.bindings.output.DigitalOutput;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class KeyMappingEmulationOutput
implements DigitalOutput {
    private final ControllerEntity controller;
    private final StateAccess stateAccess;
    private final KeyMapping keyMapping;

    public KeyMappingEmulationOutput(ControllerEntity controller, InputBinding binding, KeyMapping keyMapping, BooleanSupplier toggleCondition) {
        this.controller = controller;
        this.stateAccess = binding.createStateAccess(2, state -> this.push());
        this.keyMapping = keyMapping;
        if (toggleCondition != null) {
            ((KeyMappingHandle)keyMapping).controlify$addToggleCondition(controller, toggleCondition);
        }
    }

    @Override
    public boolean get() {
        throw new IllegalStateException("Should never retrieve output of key mapping emulation!");
    }

    private void push() {
        boolean now = this.stateAccess.digital(0);
        boolean prev = this.stateAccess.digital(1);
        if (ControlifyApi.get().getCurrentController().orElse(null) != this.controller) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        KeyMappingHandle handle = (KeyMappingHandle)this.keyMapping;
        if (now && !prev) {
            handle.controlify$setPressed(true);
        } else if (prev && !now) {
            handle.controlify$setPressed(false);
        }
    }
}

