/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import org.jetbrains.annotations.Nullable;

public final class BlockEntityTicker {
    private static final Map<ResourceKey<Level>, BlockEntityTicker> TICKERS = new Object2ObjectOpenHashMap();
    private final ResourceKey<Level> levelKey;
    private final Map<ChunkPos, Entry> blockEntityEntries = new Object2ObjectOpenHashMap();
    private final Map<ChunkPos, Entry> pendingEntries = new Object2ObjectOpenHashMap();

    private BlockEntityTicker(ResourceKey<Level> levelKey) {
        this.levelKey = levelKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntity(BlockEntity entity, Level level, ChunkPos chunkPos) {
        BlockEntityTicker ticker;
        if (LootrAPI.isDisabled()) {
            return;
        }
        ResourceKey<Level> dimension = BlockEntityTicker.getServerDimensionIfValid(level);
        if (dimension == null) {
            return;
        }
        Map<ResourceKey<Level>, BlockEntityTicker> map = TICKERS;
        synchronized (map) {
            ticker = TICKERS.computeIfAbsent(dimension, BlockEntityTicker::new);
        }
        ticker.addEntity(level, entity, chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntity(Level level, BlockEntity entity, ChunkPos chunkPos) {
        if (!LootrAPI.isWorldBorderSafe(level, chunkPos)) {
            return;
        }
        if (!BlockEntityTicker.isValidEntity(entity)) {
            return;
        }
        Map<ChunkPos, Entry> map = this.pendingEntries;
        synchronized (map) {
            Entry previousEntry = this.pendingEntries.get(chunkPos);
            if (previousEntry != null) {
                previousEntry.entityPositions.add(entity.getBlockPos());
            } else {
                HashSet<BlockPos> entityPositions = new HashSet<BlockPos>();
                entityPositions.add(entity.getBlockPos());
                Entry entry = new Entry(chunkPos, entityPositions);
                this.pendingEntries.put(chunkPos, entry);
            }
        }
    }

    private static boolean isValidEntity(BlockEntity entity) {
        if (!(entity instanceof RandomizableContainerBlockEntity)) {
            return false;
        }
        RandomizableContainerBlockEntity validEntity = (RandomizableContainerBlockEntity)entity;
        if (LootrAPI.resolveBlockEntity(validEntity) instanceof ILootrBlockEntity) {
            return false;
        }
        return validEntity.getLootTable() != null && !LootrAPI.isLootTableBlacklisted((ResourceKey<LootTable>)validEntity.getLootTable());
    }

    public static void onServerTick(MinecraftServer server) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        for (BlockEntityTicker ticker : TICKERS.values()) {
            ServerLevel level = server.getLevel(ticker.levelKey);
            if (level == null) continue;
            ticker.onServerLevelTick(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerLevelTick(ServerLevel level) {
        Set<ChunkPos> loadedChunks = LoadedChunks.getLoadedChunks((ResourceKey<Level>)level.dimension());
        Iterator<Entry> iterator = this.blockEntityEntries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            switch (entry.getChunkLoadStatus(level, loadedChunks).ordinal()) {
                case 0: {
                    iterator.remove();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    BlockEntityTicker.replaceEntitiesInChunk(level, entry);
                    iterator.remove();
                }
            }
        }
        Map<ChunkPos, Entry> map = this.pendingEntries;
        synchronized (map) {
            for (Entry entry : this.pendingEntries.values()) {
                this.blockEntityEntries.merge(entry.chunkPos, entry, (entry1, entry2) -> {
                    entry1.entityPositions.addAll(entry2.entityPositions);
                    return entry1;
                });
            }
            this.pendingEntries.clear();
        }
    }

    private static boolean checkStructureValidity(ServerLevel level, ChunkPos chunkPos, BlockPos position) {
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return true;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        if (registry.getTag(LootrTags.Structure.STRUCTURE_BLACKLIST).filter(tag -> tag.size() != 0).isPresent()) {
            return !LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_BLACKLIST, position);
        }
        if (registry.getTag(LootrTags.Structure.STRUCTURE_WHITELIST).filter(tag -> tag.size() != 0).isPresent()) {
            return LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_WHITELIST, position);
        }
        return true;
    }

    private static void replaceEntitiesInChunk(ServerLevel level, Entry entry) {
        for (BlockPos entityPos : entry.entityPositions()) {
            BlockState stateAt;
            BlockState replacement;
            BlockEntity blockEntity;
            if (!BlockEntityTicker.checkStructureValidity(level, entry.chunkPos(), entityPos) || !((blockEntity = level.getBlockEntity(entityPos)) instanceof RandomizableContainerBlockEntity)) continue;
            RandomizableContainerBlockEntity be = (RandomizableContainerBlockEntity)blockEntity;
            if (LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity) continue;
            ResourceKey table = be.getLootTable();
            if (table == null) {
                LootrAPI.LOG.warn("randomizable container \"{}\" has no loot table in {} ({})", (Object)be.getName(), (Object)level.dimension(), (Object)entityPos);
                continue;
            }
            if (LootrAPI.isLootTableBlacklisted((ResourceKey<LootTable>)table) || (replacement = LootrAPI.replacementBlockState(stateAt = level.getBlockState(entityPos))) == null) continue;
            BlockEntityTicker.replaceEntity((Level)level, entityPos, be, replacement, (ResourceKey<LootTable>)table);
        }
    }

    private static void replaceEntity(Level level, BlockPos entityPos, RandomizableContainerBlockEntity be, BlockState replacement, ResourceKey<LootTable> table) {
        DataToCopy data = PlatformAPI.copySpecificData((BlockEntity)be);
        long seed = be.getLootTableSeed();
        be.setLootTable(null);
        level.destroyBlock(entityPos, false);
        level.setBlock(entityPos, replacement, 2);
        BlockEntity newBlockEntity = level.getBlockEntity(entityPos);
        PlatformAPI.restoreSpecificData(data, newBlockEntity);
        if (LootrAPI.resolveBlockEntity(newBlockEntity) instanceof ILootrBlockEntity && newBlockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity rbe = (RandomizableContainerBlockEntity)newBlockEntity;
            rbe.setLootTable(table, seed);
        } else {
            LootrAPI.LOG.error("replacement {} is not an ILootrBlockEntity {} at {}", (Object)replacement, (Object)level.dimension(), (Object)entityPos);
        }
    }

    @Nullable
    private static ResourceKey<Level> getServerDimensionIfValid(Level level) {
        if (LootrAPI.getServer() == null || level.isClientSide()) {
            return null;
        }
        ResourceKey dimension = level.dimension();
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)dimension)) {
            return null;
        }
        return dimension;
    }

    public record Entry(ChunkPos chunkPos, Set<BlockPos> entityPositions) {
        public ChunkLoadStatus getChunkLoadStatus(ServerLevel level, Set<ChunkPos> loadedChunks) {
            ServerChunkCache chunkSource = level.getChunkSource();
            if (!LootrAPI.isWorldBorderSafe((Level)level, this.chunkPos) || !chunkSource.hasChunk(this.chunkPos.x, this.chunkPos.z)) {
                return ChunkLoadStatus.UNLOADED;
            }
            if (!loadedChunks.contains(this.chunkPos)) {
                return ChunkLoadStatus.NOT_FULLY_LOADED;
            }
            for (int x = this.chunkPos.x - 2; x <= this.chunkPos.x + 2; ++x) {
                for (int z = this.chunkPos.z - 2; z <= this.chunkPos.z + 2; ++z) {
                    ChunkPos pos;
                    if (x == this.chunkPos.x && z == this.chunkPos.z || !LootrAPI.isWorldBorderSafe((Level)level, pos = new ChunkPos(x, z)) || loadedChunks.contains(pos)) continue;
                    return ChunkLoadStatus.SURROUNDING_CHUNKS_NOT_LOADED;
                }
            }
            return ChunkLoadStatus.COMPLETE;
        }
    }

    public static enum ChunkLoadStatus {
        UNLOADED,
        SURROUNDING_CHUNKS_NOT_LOADED,
        NOT_FULLY_LOADED,
        COMPLETE;

    }
}

