/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client.screen;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.WatutMod;
import com.corosus.watut.client.screen.ByteBufferProcessor;
import com.corosus.watut.client.screen.ScreenData;
import com.corosus.watut.client.screen.ScreenParticleRenderer;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.mixin.client.NativeImageAccessor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

public class RenderHelper {
    public static boolean performingOwnRender = false;
    public static ResourceLocation cursor = ResourceLocation.fromNamespaceAndPath((String)"watut", (String)"textures/misc/mouse.png");
    public static Class guiMap;
    public static Class improvedFramebuffer;
    public static int xaeroWorldMapTextureID;
    public static Field guiMapPrimaryScaleFBO;
    public static Field colorTextureId;
    public static Class irisConfig;
    public static Class iris;
    public static Method getIrisConfig;
    public static Method areShadersEnabled;
    public static ByteBufferProcessor processor;

    public static boolean isShadersEnabled() {
        if (areShadersEnabled == null) {
            return false;
        }
        try {
            return (Boolean)areShadersEnabled.invoke(getIrisConfig.invoke(null, new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isXaeroGuiMap(Screen screen) {
        if (guiMap == null) {
            return false;
        }
        return guiMap.isInstance(screen);
    }

    public static void guiRender(GuiGraphics guiGraphics) {
        long gameTime = 0L;
        if (Minecraft.getInstance().level != null) {
            gameTime = Minecraft.getInstance().level.getGameTime();
        }
        for (PlayerStatus playerStatus : WatutMod.getPlayerStatusManagerClient().lookupPlayerToStatus.values()) {
            ScreenData screenData = playerStatus.getScreenData();
            if (!screenData.getIsBufferReady().get() || !screenData.needsNewRenderFromPixelData() || screenData.getTexturePixelData() == null || screenData.getGameTicksSinceLastScreenReceiveAndRender() + (long)ConfigClient.tickReceiveAndRenderRateOfGUIUpdates >= gameTime) continue;
            screenData.markNeedsNewRenderFromPixelData(false);
            screenData.setGameTicksSinceLastScreenReceiveAndRender(gameTime);
            ScreenParticleRenderer.getInstance().checkSetup();
            if (playerStatus.getScreenData().getParticleRenderType() == null) {
                playerStatus.getScreenData().initClient();
            }
            if (screenData.getImage() == null) {
                screenData.setImage(new DynamicTexture(screenData.getWidth(), screenData.getHeight(), true));
            } else if (screenData.getImage().getPixels().getWidth() != screenData.getWidth() || screenData.getImage().getPixels().getHeight() != screenData.getHeight()) {
                screenData.closeImage();
                screenData.setImage(new DynamicTexture(screenData.getWidth(), screenData.getHeight(), true));
                CULog.dbg((String)("screendata image resized to " + screenData.getWidth() + " " + screenData.getHeight()));
            }
            long nativeImagePixelMemoryAddress = ((NativeImageAccessor)screenData.getImage().getPixels()).pixels();
            if (nativeImagePixelMemoryAddress != -1L) {
                MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)screenData.getDecompressionBuffer()), (long)nativeImagePixelMemoryAddress, (long)(screenData.getWidth() * screenData.getHeight() * ScreenParticleRenderer.bytesPerPixel));
            }
            screenData.getImage().upload();
            playerStatus.getScreenData().getIsBufferReady().set(false);
        }
    }

    public static void bindVanillaRenderTargetAndSetupProjectionMatrix() {
        Window window = Minecraft.getInstance().getWindow();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, WatutMod.instance().getFarPlane());
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    public static void unbindVanillaRenderTarget() {
        Minecraft.getInstance().getMainRenderTarget().unbindWrite();
    }

    public static boolean useDynamicGUISystem() {
        if (ConfigServerControlledSyncedToClient.dynamicGuiUseOldSimpleGUIVisual) {
            return false;
        }
        return !ConfigClient.dontSendDetailedGUIInfo;
    }

    public static synchronized void renderWithTooltipEnd(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean needsScreenUpdate;
        if (!RenderHelper.useDynamicGUISystem()) {
            return;
        }
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return;
        }
        PlayerStatus playerStatusLocal = WatutMod.getPlayerStatusManagerClient().getStatusLocal();
        if (processor.hasProcessedBuffers()) {
            try {
                ByteBuffer result = processor.getProcessedBuffer();
                if (result != null) {
                    ScreenData screenDataLocal = playerStatusLocal.getScreenData();
                    screenDataLocal.setTexturePixelData(result);
                    WatutMod.getPlayerStatusManagerClient().sendScreenRenderData(playerStatusLocal);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if ((needsScreenUpdate = playerStatusLocal.getScreenData().isNeedsNewRenderToPixelData()) && !processor.hasWork()) {
            playerStatusLocal.getScreenData().setNeedsNewRenderToPixelData(false);
            ScreenParticleRenderer.getInstance().checkSetup();
            RenderHelper.unbindVanillaRenderTarget();
            ScreenParticleRenderer.getInstance().bind();
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            if (Minecraft.getInstance().screen != null) {
                if (ConfigServerControlledSyncedToClient.dynamicGuiDisableBackgroundRendering) {
                    ScreenParticleRenderer.isRenderingParticleGUI = true;
                    ScreenParticleRenderer.isRenderingParticleGUI2 = true;
                }
                performingOwnRender = true;
                xaeroWorldMapTextureID = -1;
                if (RenderHelper.isXaeroGuiMap(Minecraft.getInstance().screen)) {
                    try {
                        Object colorTextureIdObj;
                        Object fbo = guiMapPrimaryScaleFBO.get(null);
                        if (fbo != null && (colorTextureIdObj = colorTextureId.get(fbo)) != null) {
                            xaeroWorldMapTextureID = (Integer)colorTextureIdObj;
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    Minecraft.getInstance().screen.renderWithTooltip(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
                ScreenParticleRenderer.getInstance().innerBlit(pGuiGraphics.pose(), cursor, pMouseX, pMouseX + 6, pMouseY, pMouseY + 10, 100, 0.0f, 1.0f, 0.0f, 1.0f);
                performingOwnRender = false;
                ScreenParticleRenderer.isRenderingParticleGUI = false;
                ScreenParticleRenderer.isRenderingParticleGUI2 = false;
            }
            ScreenParticleRenderer.getInstance().unbind();
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)ScreenParticleRenderer.getInstance().widthScaledDown, (float)ScreenParticleRenderer.getInstance().heightScaledDown, 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            ScreenParticleRenderer.getInstance().bindScaledDown();
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
            if (ConfigServerControlledSyncedToClient.dynamicGuiShowClientsEntireScreen) {
                guiScale = 1.0;
            }
            int croppedWidth = (int)((double)ScreenParticleRenderer.getInstance().widthScaledDown * guiScale);
            int croppedHeight = (int)((double)ScreenParticleRenderer.getInstance().heightScaledDown * guiScale);
            int centerX = ScreenParticleRenderer.getInstance().width / 2;
            int centerY = ScreenParticleRenderer.getInstance().height / 2;
            int x1 = centerX - croppedWidth / 2;
            int x2 = centerX + croppedWidth / 2;
            int y1 = centerY - croppedHeight / 2;
            int y2 = centerY + croppedHeight / 2;
            float minU = (float)x1 / (float)ScreenParticleRenderer.getInstance().width;
            float maxU = (float)x2 / (float)ScreenParticleRenderer.getInstance().width;
            float minV = (float)y1 / (float)ScreenParticleRenderer.getInstance().height;
            float maxV = (float)y2 / (float)ScreenParticleRenderer.getInstance().height;
            x1 = 0;
            x2 = ScreenParticleRenderer.getInstance().widthScaledDown;
            y1 = 0;
            y2 = ScreenParticleRenderer.getInstance().heightScaledDown;
            boolean useBlur = true;
            if (useBlur) {
                ScreenParticleRenderer.getInstance().innerBlitCustomShaderHorizontal(pGuiGraphics.pose(), x1, x2, y1, y2, 0, minU, maxU, minV, maxV);
                ScreenParticleRenderer.getInstance().innerBlitCustomShaderVertical(pGuiGraphics.pose(), 0, ScreenParticleRenderer.getInstance().widthScaledDown, 0, ScreenParticleRenderer.getInstance().heightScaledDown, 0, 0.0f, 1.0f, 0.0f, 1.0f);
            } else {
                ScreenParticleRenderer.getInstance().innerBlitCustomShader(pGuiGraphics.pose(), x1, x2, y1, y2, 0, minU, maxU, minV, maxV);
            }
            ByteBuffer pixelBuffer = RenderHelper.getPixelDataFromFrameBuffer();
            boolean useThread = true;
            if (useThread) {
                processor.submitForProcessing(pixelBuffer);
            } else {
                ByteBuffer byteBuffer = RenderHelper.compress(pixelBuffer);
                playerStatusLocal.getScreenData().setTexturePixelData(byteBuffer);
                WatutMod.getPlayerStatusManagerClient().sendScreenRenderData(playerStatusLocal);
            }
            ScreenParticleRenderer.getInstance().unbindScaledDown();
            RenderHelper.bindVanillaRenderTargetAndSetupProjectionMatrix();
        }
    }

    public static ByteBuffer compress(ByteBuffer inputBuffer) {
        Deflater deflater = new Deflater(9);
        byte[] inputBytes = new byte[inputBuffer.remaining()];
        inputBuffer.get(inputBytes);
        deflater.setInput(inputBytes);
        deflater.finish();
        ByteBuffer outputBuffer = ByteBuffer.allocateDirect(inputBytes.length + 512);
        byte[] temp = new byte[1024];
        while (!deflater.finished()) {
            int compressedBytes = deflater.deflate(temp);
            if (outputBuffer.remaining() < compressedBytes) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(outputBuffer.capacity() * 2);
                outputBuffer.flip();
                newBuffer.put(outputBuffer);
                outputBuffer = newBuffer;
            }
            outputBuffer.put(temp, 0, compressedBytes);
        }
        deflater.end();
        outputBuffer.flip();
        inputBuffer.flip();
        return outputBuffer;
    }

    public static ByteBuffer decompress(ScreenData screenData, ByteBuffer compressedBuffer, int expectedSize) throws Exception {
        Inflater inflater = new Inflater();
        byte[] compressedBytes = new byte[compressedBuffer.remaining()];
        compressedBuffer.get(compressedBytes);
        inflater.setInput(compressedBytes);
        ByteBuffer decompressionBuffer = screenData.getDecompressionBuffer();
        if (decompressionBuffer == null) {
            CULog.dbg((String)"Creating new buffer for decompression");
            decompressionBuffer = MemoryUtil.memAlloc((int)expectedSize);
            screenData.setDecompressionBuffer(decompressionBuffer);
        } else {
            decompressionBuffer.clear();
        }
        byte[] temp = new byte[1024];
        while (!inflater.finished()) {
            int decompressedBytes = inflater.inflate(temp);
            if (decompressionBuffer.remaining() < decompressedBytes) {
                int newCapacity = Math.max(decompressionBuffer.capacity() * 2, decompressionBuffer.capacity() + decompressedBytes);
                CULog.dbg((String)"adjusting size of buffer for decompression");
                ByteBuffer newBuffer = MemoryUtil.memAlloc((int)newCapacity);
                decompressionBuffer.flip();
                newBuffer.put(decompressionBuffer);
                MemoryUtil.memFree((Buffer)decompressionBuffer);
                decompressionBuffer = newBuffer;
                screenData.setDecompressionBuffer(decompressionBuffer);
            }
            decompressionBuffer.put(temp, 0, decompressedBytes);
        }
        inflater.end();
        decompressionBuffer.flip();
        return decompressionBuffer;
    }

    public static ByteBuffer decompress2(ScreenData screenData, ByteBuffer compressedBuffer, int expectedSize) throws Exception {
        Inflater inflater = new Inflater();
        byte[] compressedBytes = new byte[compressedBuffer.remaining()];
        compressedBuffer.get(compressedBytes);
        inflater.setInput(compressedBytes);
        ByteBuffer decompressionBuffer = screenData.getDecompressionBuffer();
        if (decompressionBuffer == null) {
            System.out.println("make new buffer");
            decompressionBuffer = ByteBuffer.allocateDirect(expectedSize);
            screenData.setDecompressionBuffer(decompressionBuffer);
        } else {
            decompressionBuffer.clear();
        }
        byte[] temp = new byte[1024];
        while (!inflater.finished()) {
            int decompressedBytes = inflater.inflate(temp);
            if (decompressionBuffer.remaining() < decompressedBytes) {
                throw new IllegalStateException("Decompressed size exceeds expected size!");
            }
            decompressionBuffer.put(temp, 0, decompressedBytes);
        }
        inflater.end();
        decompressionBuffer.flip();
        return decompressionBuffer;
    }

    public static ByteBuffer decompressGZIP(ByteBuffer compressedBuffer) throws IOException {
        int bytesRead;
        byte[] compressedBytes = new byte[compressedBuffer.remaining()];
        compressedBuffer.get(compressedBytes);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedBytes);
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        gzipInputStream.close();
        byteArrayInputStream.close();
        byte[] decompressedBytes = byteArrayOutputStream.toByteArray();
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(decompressedBytes.length);
        directBuffer.put(decompressedBytes);
        directBuffer.flip();
        return directBuffer;
    }

    public static ByteBuffer compressGZIP(ByteBuffer inputBuffer) throws IOException {
        byte[] inputBytes = new byte[inputBuffer.remaining()];
        inputBuffer.get(inputBytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(inputBytes);
        }
        byte[] compressedBytes = byteArrayOutputStream.toByteArray();
        return ByteBuffer.wrap(compressedBytes);
    }

    public static ByteBuffer getPixelDataFromFrameBuffer() {
        int width = ScreenParticleRenderer.getInstance().widthScaledDown;
        int height = ScreenParticleRenderer.getInstance().heightScaledDown;
        ByteBuffer pixelBuffer = ByteBuffer.allocateDirect(width * height * ScreenParticleRenderer.bytesPerPixel);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
        return pixelBuffer;
    }

    public static boolean validatePixelByteBuffer(ByteBuffer byteBuffer, int expectedSize, int expectedAlignment) {
        if (byteBuffer == null) {
            return false;
        }
        return byteBuffer.limit() == expectedSize;
    }

    static {
        xaeroWorldMapTextureID = -1;
        try {
            guiMap = Class.forName("xaero.map.gui.GuiMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            improvedFramebuffer = Class.forName("xaero.map.graphics.ImprovedFramebuffer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            iris = Class.forName("net.irisshaders.iris.Iris");
            irisConfig = Class.forName("net.irisshaders.iris.config.IrisConfig");
            getIrisConfig = iris.getDeclaredMethod("getIrisConfig", new Class[0]);
            areShadersEnabled = irisConfig.getDeclaredMethod("areShadersEnabled", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            try {
                iris = Class.forName("net.coderbot.iris.Iris");
                irisConfig = Class.forName("net.coderbot.iris.config.IrisConfig");
                getIrisConfig = iris.getDeclaredMethod("getIrisConfig", new Class[0]);
                areShadersEnabled = irisConfig.getDeclaredMethod("areShadersEnabled", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
                CULog.log((String)"watut: oculus not installed or mod structure changed");
            }
            catch (NoSuchMethodException ex) {
                CULog.log((String)"watut: oculus not installed or mod structure changed");
            }
        }
        catch (NoSuchMethodException e) {
            CULog.log((String)"watut: oculus not installed or mod structure changed");
        }
        try {
            improvedFramebuffer = Class.forName("xaero.map.graphics.ImprovedFramebuffer");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (guiMap != null) {
                guiMapPrimaryScaleFBO = guiMap.getDeclaredField("primaryScaleFBO");
                guiMapPrimaryScaleFBO.setAccessible(true);
            }
            if (improvedFramebuffer != null) {
                colorTextureId = improvedFramebuffer.getDeclaredField("colorTextureId");
            } else {
                CULog.log((String)"watut: xaero minimap not installed or mod structure changed");
            }
        }
        catch (NoSuchFieldException e) {
            CULog.log((String)"watut: xaero minimap not installed or mod structure changed");
        }
        processor = new ByteBufferProcessor(buffer -> {
            ByteBuffer processed = RenderHelper.compress(buffer);
            return processed;
        });
    }
}

