/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import fi.dy.masa.malilib.event.IServerManager;
import fi.dy.masa.malilib.interfaces.IServerListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class ServerHandler
implements IServerManager {
    private static final ServerHandler INSTANCE = new ServerHandler();
    private final List<IServerListener> handlers = new ArrayList<IServerListener>();

    public static IServerManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerServerHandler(IServerListener handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void unregisterServerHandler(IServerListener handler) {
        this.handlers.remove(handler);
    }

    @ApiStatus.Internal
    public void onServerStarting(MinecraftServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerStarting(server);
            }
        }
    }

    @ApiStatus.Internal
    public void onServerStarted(MinecraftServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerStarted(server);
            }
        }
    }

    @ApiStatus.Internal
    public void onServerIntegratedSetup(IntegratedServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerIntegratedSetup(server);
            }
        }
    }

    @ApiStatus.Internal
    public void onServerOpenToLan(IntegratedServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerOpenToLan(server);
            }
        }
    }

    @ApiStatus.Internal
    public void onServerStopping(MinecraftServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerStopping(server);
            }
        }
    }

    @ApiStatus.Internal
    public void onServerStopped(MinecraftServer server) {
        if (!this.handlers.isEmpty()) {
            for (IServerListener handler : this.handlers) {
                handler.onServerStopped(server);
            }
        }
    }
}

