/*
 * Decompiled with CFR 0.152.
 */
package jeresources.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.platform.Services;
import jeresources.registry.WorldGenRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorldGenAdapter {
    private static final String worldGenFileName = "world-gen.json";
    private static Map<ResourceKey<Level>, Restriction> map = new HashMap<ResourceKey<Level>, Restriction>();

    public static File getWorldGenFile() {
        return Services.PLATFORM.getConfigDir().resolve(worldGenFileName).toFile();
    }

    public static boolean hasWorldGenDIYData() {
        return WorldGenAdapter.getWorldGenFile().exists();
    }

    public static boolean readDIYData() {
        try {
            JsonElement base = JsonParser.parseReader((Reader)new FileReader(WorldGenAdapter.getWorldGenFile()));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) {
                return false;
            }
            JsonArray array = base.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                JsonElement element = obj.get("mod");
                if (element != null && !Services.PLATFORM.getModsList().isLoaded(element.getAsString())) continue;
                String block = obj.get("block").getAsString();
                JsonElement distribElement = obj.get("distrib");
                if (distribElement == null) continue;
                String distrib = distribElement.getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();
                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";
                String[] blockParts = block.split(":");
                Item itemBlock = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)blockParts[0], (String)blockParts[1]));
                if (itemBlock == Items.AIR) {
                    itemBlock = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)blockParts[0], (String)blockParts[1]))).asItem();
                }
                if (itemBlock == Items.AIR) continue;
                ItemStack blockStack = itemBlock.getDefaultInstance();
                ArrayList<DistributionHelpers.OrePoint> points = new ArrayList<DistributionHelpers.OrePoint>();
                for (String point : distrib.split(";")) {
                    String[] split = point.split(",");
                    if (split.length != 2) continue;
                    points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                }
                DistributionCustom distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints(points.toArray(new DistributionHelpers.OrePoint[points.size()])));
                JsonElement dropsListElement = obj.get("dropsList");
                LinkedList<LootDrop> dropList = new LinkedList<LootDrop>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonElement fortuneElement;
                        String itemStackString;
                        String[] stackStrings;
                        Item item;
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull() || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)(stackStrings = (itemStackString = itemStackElement.getAsString()).split(":", 4))[0], (String)stackStrings[1]))) == Items.AIR) continue;
                        ItemStack itemStack = new ItemStack((ItemLike)item);
                        if (stackStrings.length >= 3) {
                            itemStack.setDamageValue(Integer.valueOf(stackStrings[2]).intValue());
                        }
                        if (stackStrings.length == 4) {
                            // empty if block
                        }
                        if ((fortuneElement = drop.get("fortunes")) == null) continue;
                        JsonObject fortunes = fortuneElement.getAsJsonObject();
                        for (Map.Entry fortuneValue : fortunes.entrySet()) {
                            int fortuneLevel = Integer.parseInt((String)fortuneValue.getKey());
                            float dropAmount = ((JsonElement)fortuneValue.getValue()).getAsFloat();
                            dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                        }
                    }
                }
                if ((blockStack.isEmpty() || blockStack.getItem() == Items.AIR) && dropList.size() > 0) {
                    blockStack = ((LootDrop)dropList.get((int)0)).item.copy();
                    blockStack.setCount(1);
                }
                WorldGenRegistry.getInstance().registerEntry(new WorldGenEntry(blockStack, (DistributionBase)distribution, WorldGenAdapter.getRestriction(dim), silktouch, dropList.toArray(new LootDrop[dropList.size()])));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Restriction getRestriction(String dim) {
        ResourceKey worldRegistryKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dim));
        return map.computeIfAbsent((ResourceKey<Level>)worldRegistryKey, k -> new Restriction(new DimensionRestriction((ResourceKey<Level>)worldRegistryKey)));
    }
}

