/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public class ChunkCacheSchematic
implements BlockAndTintGetter,
LightChunkGetter {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected final Level world;
    protected final ClientLevel worldClient;
    protected int chunkStartX;
    protected int chunkStartZ;
    protected LevelChunk[][] chunkArray;
    protected boolean empty;

    public ChunkCacheSchematic(@Nonnull Level worldIn, @Nonnull ClientLevel clientWorld, @Nonnull BlockPos pos, int expand) {
        this.world = worldIn;
        this.worldClient = clientWorld;
        int chunkX = pos.getX() >> 4;
        int chunkZ = pos.getZ() >> 4;
        this.chunkStartX = pos.getX() - expand >> 4;
        this.chunkStartZ = pos.getZ() - expand >> 4;
        int chunkEndX = pos.getX() + expand + 15 >> 4;
        int chunkEndZ = pos.getZ() + expand + 15 >> 4;
        this.chunkArray = new LevelChunk[chunkEndX - this.chunkStartX + 1][chunkEndZ - this.chunkStartZ + 1];
        this.empty = true;
        for (int cx = this.chunkStartX; cx <= chunkEndX; ++cx) {
            for (int cz = this.chunkStartZ; cz <= chunkEndZ; ++cz) {
                LevelChunk chunk;
                this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ] = chunk = worldIn.getChunk(cx, cz);
                if (cx != chunkX || cz != chunkZ || chunk.isYSpaceEmpty(worldIn.getMinBuildHeight(), worldIn.getMaxBuildHeight() - 1)) continue;
                this.empty = false;
            }
        }
    }

    public BlockGetter getLevel() {
        return this.world;
    }

    public LightChunk getChunkForLighting(int chunkX, int chunkZ) {
        return this.worldClient.getChunk(chunkX, chunkZ);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunk chunk;
        int cx = (pos.getX() >> 4) - this.chunkStartX;
        int cz = (pos.getZ() >> 4) - this.chunkStartZ;
        if (cx >= 0 && cx < this.chunkArray.length && cz >= 0 && cz < this.chunkArray[cx].length && (chunk = this.chunkArray[cx][cz]) != null) {
            return chunk.getBlockState(pos);
        }
        return AIR;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, LevelChunk.EntityCreationType type) {
        int i = (pos.getX() >> 4) - this.chunkStartX;
        int j = (pos.getZ() >> 4) - this.chunkStartZ;
        return this.chunkArray[i][j].getBlockEntity(pos, type);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public LevelLightEngine getLightEngine() {
        return this.world.getLightEngine();
    }

    public int getBlockTint(BlockPos pos, ColorResolver colorResolver) {
        return colorResolver.getColor((Biome)this.worldClient.getBiome(pos).value(), (double)pos.getX(), (double)pos.getZ());
    }

    public float getShade(Direction direction, boolean bl) {
        return this.worldClient.getShade(direction, bl);
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public int getMinBuildHeight() {
        return this.world.getMinBuildHeight();
    }
}

