/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.compat.iris.IrisCompat;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4f;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private Minecraft mc;
    private WorldRendererSchematic worldRenderer;
    private Frustum frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.getInstance();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public WorldRendererSchematic resetWorldRenderer() {
        if (this.worldRenderer != null) {
            this.worldRenderer.setWorldAndLoadRenderers(null);
            this.worldRenderer = null;
        }
        return this.getWorldRenderer();
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + 1000000000L / fpsTarget / 2L;
    }

    public void renderSchematicOverlay(Matrix4f matrix4f, Matrix4f projMatrix) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            this.mc.getProfiler().push("litematica_schematic_overlay");
            RenderSystem.disableCull();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!IrisCompat.isShadowPassActive()) {
                this.getWorldRenderer().renderBlockOverlays(matrix4f, this.getCamera(), projMatrix);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
            this.mc.getProfiler().pop();
        }
    }

    public void piecewisePrepareAndUpdate(Frustum frustum) {
        boolean render = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.getCameraEntity() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (render && frustum != null && worldRenderer.hasWorld()) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            if (this.renderPiecewiseSchematic) {
                this.mc.getProfiler().push("litematica_culling");
                this.calculateFinishTime();
                this.mc.getProfiler().popPush("litematica_terrain_setup");
                worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.player.isSpectator());
                this.mc.getProfiler().popPush("litematica_update_chunks");
                worldRenderer.updateChunks(this.finishTimeNano);
                this.mc.getProfiler().pop();
                this.frustum = frustum;
            }
        }
    }

    public void piecewiseRenderSolid(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.getProfiler().push("litematica_blocks_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            RenderSystem.setShader(GameRenderer::getRendertypeSolidShader);
            this.getWorldRenderer().renderBlockLayer(RenderType.solid(), matrix4f, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.getProfiler().pop();
        }
    }

    public void piecewiseRenderCutoutMipped(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.getProfiler().push("litematica_blocks_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            RenderSystem.setShader(GameRenderer::getRendertypeCutoutMippedShader);
            this.getWorldRenderer().renderBlockLayer(RenderType.cutoutMipped(), matrix4f, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.getProfiler().pop();
        }
    }

    public void piecewiseRenderCutout(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.getProfiler().push("litematica_blocks_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            RenderSystem.setShader(GameRenderer::getRendertypeCutoutShader);
            this.getWorldRenderer().renderBlockLayer(RenderType.cutout(), matrix4f, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.getProfiler().pop();
        }
    }

    public void piecewiseRenderTranslucent(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.getProfiler().push("litematica_translucent");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            RenderSystem.setShader(GameRenderer::getRendertypeTranslucentShader);
            this.getWorldRenderer().renderBlockLayer(RenderType.translucent(), matrix4f, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.getProfiler().pop();
        }
    }

    public void piecewiseRenderOverlay(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (this.renderPiecewiseSchematic) {
            RenderTarget fb;
            this.mc.getProfiler().push("litematica_overlay");
            RenderTarget renderTarget = fb = Minecraft.useShaderTransparency() ? this.mc.levelRenderer.getTranslucentTarget() : null;
            if (fb != null) {
                fb.bindWrite(false);
            }
            this.renderSchematicOverlay(matrix4f, projMatrix);
            if (fb != null) {
                this.mc.getMainRenderTarget().bindWrite(false);
            }
            this.mc.getProfiler().pop();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(Matrix4f matrix4f, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.getProfiler().push("litematica_entities");
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrix4f, partialTicks);
            this.mc.getProfiler().pop();
        }
    }

    private Camera getCamera() {
        return this.mc.gameRenderer.getMainCamera();
    }

    private void cleanup() {
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
    }
}

