/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDrawer
extends Slot {
    private static final Container emptyInventory = new EmptyInventory();
    private final ContainerDrawers container;
    private final IDrawerGroup group;
    private final IDrawer drawer;

    public SlotDrawer(ContainerDrawers container, IDrawerGroup drawerGroup, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.container = container;
        this.group = drawerGroup;
        this.drawer = this.group.getDrawer(index);
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return !stack.isEmpty() && this.drawer.canItemBeStored(stack);
    }

    @NotNull
    public ItemStack getItem() {
        ItemStack stack = ItemStackHelper.encodeItemStack(this.drawer.getStoredItemPrototype(), this.drawer.getStoredItemCount());
        this.container.setLastAccessedItem(stack);
        return stack;
    }

    public void set(@NotNull ItemStack stack) {
        IDrawer target = this.drawer.setStoredItem(stack);
        stack = ItemStackHelper.decodeItemStack(stack);
        target.setStoredItemCount(stack.getCount());
    }

    public void onQuickCraft(@NotNull ItemStack p_75220_1_, @NotNull ItemStack p_75220_2_) {
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return Math.min(stack.getMaxStackSize(), this.drawer.getRemainingCapacity());
    }

    public boolean mayPickup(@NotNull Player playerIn) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        int withdraw = Math.min(amount, this.drawer.getStoredItemCount());
        this.drawer.setStoredItemCount(withdraw);
        ItemStack stack = this.drawer.getStoredItemPrototype().copy();
        stack.setCount(this.drawer.getStoredItemCount() - withdraw);
        return stack;
    }

    public IDrawerGroup getDrawerGroup() {
        return this.group;
    }

    public IDrawer getDrawer() {
        return this.drawer;
    }

    public boolean isSameInventory(@NotNull Slot other) {
        return other instanceof SlotDrawer && ((SlotDrawer)other).getDrawerGroup() == this.group;
    }

    static class EmptyInventory
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyInventory() {
            super(0);
        }

        public int[] getSlotsForFace(@NotNull Direction side) {
            return new int[0];
        }

        public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
            return false;
        }
    }
}

