/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator;

import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.compat.playeranimator.animation.AnimationDataRegisterFactory;
import com.tacz.guns.compat.playeranimator.animation.AnimationManager;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorAssetManager;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorLoader;
import java.io.File;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;

public class PlayerAnimatorCompat {
    public static ResourceLocation LOWER_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"lower_animation");
    public static ResourceLocation LOOP_UPPER_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"loop_upper_animation");
    public static ResourceLocation ONCE_UPPER_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"once_upper_animation");
    public static ResourceLocation ROTATION_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"rotation");
    private static final String MOD_ID = "playeranimator";
    private static boolean INSTALLED = false;

    public static void init() {
        INSTALLED = ModList.get().isLoaded(MOD_ID);
        if (PlayerAnimatorCompat.isInstalled()) {
            AnimationDataRegisterFactory.registerData();
            NeoForge.EVENT_BUS.register((Object)new AnimationManager());
        }
    }

    public static boolean loadAnimationFromZip(ZipFile zipFile, String zipPath) {
        if (PlayerAnimatorCompat.isInstalled()) {
            return PlayerAnimatorLoader.load(zipFile, zipPath);
        }
        return false;
    }

    public static void loadAnimationFromFile(File file) {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorLoader.load(file);
        }
    }

    public static void clearAllAnimationCache() {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorAssetManager.get().clearAll();
        }
    }

    public static boolean hasPlayerAnimator3rd(LivingEntity livingEntity, GunDisplayInstance display) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            return AnimationManager.hasPlayerAnimator3rd(display);
        }
        return false;
    }

    public static void stopAllAnimation(LivingEntity livingEntity) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            AnimationManager.stopAllAnimation(player);
        }
    }

    public static void stopAllAnimation(LivingEntity livingEntity, int fadeTime) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            AnimationManager.stopAllAnimation(player, fadeTime);
        }
    }

    public static void playAnimation(LivingEntity livingEntity, GunDisplayInstance display, float limbSwingAmount) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            AnimationManager.playLowerAnimation(player, display, limbSwingAmount);
            AnimationManager.playLoopUpperAnimation(player, display, limbSwingAmount);
            AnimationManager.playRotationAnimation(player, display);
        }
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }

    public static void registerReloadListener(Consumer<PreparableReloadListener> register) {
        if (PlayerAnimatorCompat.isInstalled()) {
            register.accept((PreparableReloadListener)PlayerAnimatorAssetManager.get());
        }
    }
}

