/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HeatBarOverlay {
    private static final ResourceLocation HEATBASE = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/heat_base.png");
    private static final DecimalFormat HEAT_FORMAT_PERCENT = new DecimalFormat("0.0%");
    private static float heatScale = 0.25f;

    public static void render(GuiGraphics graphics, int guiTicks, float partialTick, int width, int height) {
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        if (gunData.getHeatData() != null && iGun.hasHeatData(stack)) {
            poseStack.pushPose();
            GunHeatData heatData = gunData.getHeatData();
            float percent = iGun.getHeatAmount(stack) / heatData.getHeatMax();
            float scaleValue = iGun.getHeatAmount(stack) / heatData.getHeatMax() / 8.0f + 0.75f;
            if (heatScale < scaleValue) {
                heatScale += 0.05f;
            }
            if (heatScale > scaleValue) {
                heatScale -= 0.025f;
            }
            if ((double)heatScale > (double)scaleValue - 0.03 && (double)heatScale < (double)scaleValue + 0.055) {
                heatScale = scaleValue;
            }
            poseStack.scale(heatScale, heatScale, 1.0f);
            boolean locked = iGun.isOverheatLocked(stack);
            HeatBarOverlay.renderOverheat(percent, graphics, (int)((float)width / heatScale), (int)((float)height / heatScale), locked, guiTicks);
            poseStack.popPose();
        }
    }

    public static void renderOverheat(float heatPercentage, GuiGraphics pGraphics, int w, int h, boolean locked, int tickCount) {
        String percentString;
        int barColor = HeatBarOverlay.getHeatColor(heatPercentage, locked, tickCount);
        pGraphics.fill(w / 2 - 30, h / 2 + 30, w / 2 - 30 + (int)(heatPercentage * 60.0f), h / 2 + 34, barColor);
        if (locked) {
            if (tickCount % 20 < 10) {
                pGraphics.setColor(1.0f, 0.1f, 0.1f, 1.0f);
            } else {
                pGraphics.setColor(1.0f, 1.0f, 0.1f, 1.0f);
            }
        }
        pGraphics.blit(HEATBASE, w / 2 - 64, h / 2 - 44, 0.0f, 0.0f, 128, 128, 128, 128);
        pGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        Font font = Minecraft.getInstance().fontFilterFishy;
        String string = percentString = locked ? "!OVERHEAT!" : HEAT_FORMAT_PERCENT.format(heatPercentage);
        int color = locked ? (tickCount % 20 < 10 ? -65536 : -256) : -1;
        pGraphics.drawString(font, percentString, w / 2 - font.width(percentString) / 2, h / 2 + 38, color, true);
    }

    public static int getHeatColor(float percent, boolean locked, int tickCount) {
        if (locked) {
            return tickCount % 20 < 10 ? -1610678272 : -1610612992;
        }
        if ((double)percent < 0.4) {
            return -1610612737;
        }
        int color = (double)percent <= 0.65 ? FastColor.ARGB32.lerp((float)(percent * 4.0f - 1.6f), (int)-1610612737, (int)-1610612992) : FastColor.ARGB32.lerp((float)((percent - 0.65f) / 0.35f), (int)-1610612992, (int)-1610678272);
        return color;
    }
}

