/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.renderer.other.HandRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class FirstPersonRenderEvent {
    private static AnimationStateMachine<?> lastStateMachine = null;

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (event.getHand() == InteractionHand.OFF_HAND) {
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            if (stack.getItem() instanceof IGun) {
                event.setCanceled(true);
            }
            return;
        }
        ItemStack stack = event.getItemStack();
        ItemDisplayContext transformType = event.getHand() == InteractionHand.MAIN_HAND ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof AnimateGeoItemRenderer) {
            boolean flag;
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)blockEntityWithoutLevelRenderer;
            LuaAnimationStateMachine machine = renderer.getStateMachine(stack);
            if (machine != lastStateMachine) {
                if (lastStateMachine != null && lastStateMachine.isInitialized()) {
                    lastStateMachine.exit();
                }
                lastStateMachine = machine;
            }
            if ((flag = ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)stack)) && renderer.needReInit(stack)) {
                renderer.tryInit(stack, (Player)player, event.getPartialTick());
            }
            GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
            HandRenderer.INSTANCE.renderSolid(poseStack -> renderer.renderFirstPerson(player, stack, transformType, poseStack == null ? event.getPoseStack() : poseStack, event.getMultiBufferSource(), event.getPackedLight(), event.getPartialTick()), event.getPartialTick(), gameRenderer.getMainCamera(), gameRenderer);
            event.setCanceled(true);
        }
    }
}

