/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client.screen;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.PlayerStatusManagerClient;
import com.corosus.watut.client.screen.RenderHelper;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ScreenParticleRenderer {
    public static boolean isRenderingParticleGUI = false;
    public static boolean isRenderingParticleGUI2 = false;
    private MainTarget mainRenderTarget;
    private MainTarget mainRenderTargetScaledDown;
    public int width;
    public int height;
    public static int defaultWidthScaledDown = 256;
    public static int defaultHeightScaledDown = 256;
    public static int bytesPerPixel = 4;
    public int widthScaledDown = defaultWidthScaledDown;
    public int heightScaledDown = defaultHeightScaledDown;
    public boolean needsInit = true;
    private static ScreenParticleRenderer instance;

    public static ScreenParticleRenderer getInstance() {
        if (instance == null) {
            instance = new ScreenParticleRenderer();
        }
        return instance;
    }

    public void checkSetup() {
        if (this.needsInit) {
            this.needsInit = false;
            this.setup();
        }
    }

    public void setup() {
        Minecraft mc = Minecraft.getInstance();
        this.width = mc.getWindow().getWidth();
        this.height = mc.getWindow().getHeight();
        this.mainRenderTarget = new MainTarget(this.width, this.height);
        this.mainRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.mainRenderTarget.clear(Minecraft.ON_OSX);
        if (ConfigServerControlledSyncedToClient.dynamicGuiShowClientsEntireScreen) {
            this.widthScaledDown = this.width;
            this.heightScaledDown = this.height;
        } else {
            this.widthScaledDown = defaultWidthScaledDown;
            this.heightScaledDown = defaultHeightScaledDown;
        }
        this.mainRenderTargetScaledDown = new MainTarget(this.widthScaledDown, this.heightScaledDown);
        this.mainRenderTargetScaledDown.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.mainRenderTargetScaledDown.clear(Minecraft.ON_OSX);
    }

    public synchronized void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.checkSetup();
        this.mainRenderTarget.resize(width, height, Minecraft.ON_OSX);
        this.resizeScaledDown(width, height);
    }

    public void resizeScaledDown(int width, int height) {
        int widthToUse = defaultWidthScaledDown;
        int heightToUse = defaultHeightScaledDown;
        if (ConfigServerControlledSyncedToClient.dynamicGuiShowClientsEntireScreen) {
            widthToUse = width;
            heightToUse = height;
        }
        this.widthScaledDown = widthToUse;
        this.heightScaledDown = heightToUse;
        CULog.dbg((String)("resizeScaledDown to " + widthToUse + " " + heightToUse));
        if (this.mainRenderTargetScaledDown.width != widthToUse || this.mainRenderTargetScaledDown.height != heightToUse) {
            this.mainRenderTargetScaledDown.resize(widthToUse, heightToUse, Minecraft.ON_OSX);
        }
    }

    public void bind() {
        this.mainRenderTarget.bindWrite(true);
    }

    public void unbind() {
        this.mainRenderTarget.unbindWrite();
    }

    public void bindScaledDown() {
        this.mainRenderTargetScaledDown.bindWrite(true);
    }

    public void unbindScaledDown() {
        this.mainRenderTargetScaledDown.unbindWrite();
    }

    public MainTarget getMainRenderTarget() {
        return this.mainRenderTarget;
    }

    public MainTarget getMainRenderTargetScaledDown() {
        return this.mainRenderTargetScaledDown;
    }

    public void setMainRenderTarget(MainTarget mainRenderTarget) {
        this.mainRenderTarget = mainRenderTarget;
    }

    public void innerBlitCustomShader(PoseStack pose, int p_281399_, int p_283222_, int p_283615_, int p_283430_, int p_281729_, float p_283247_, float p_282598_, float p_282883_, float p_283017_) {
        RenderSystem._setShaderTexture((int)0, (int)this.mainRenderTarget.getColorTextureId());
        RenderSystem.setShader(() -> PlayerStatusManagerClient.positionTexBlur);
        if (PlayerStatusManagerClient.positionTexBlur == null) {
            return;
        }
        if (PlayerStatusManagerClient.positionTexBlur.RESOLUTION != null) {
            int sizeX = ScreenParticleRenderer.getInstance().widthScaledDown;
            int sizeY = ScreenParticleRenderer.getInstance().heightScaledDown;
            PlayerStatusManagerClient.positionTexBlur.RESOLUTION.set((float)sizeX, (float)sizeY);
        }
        if (PlayerStatusManagerClient.positionTexBlur.RADIUS != null) {
            PlayerStatusManagerClient.positionTexBlur.RADIUS.set(0.0f);
        }
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283615_, (float)p_281729_).setUv(p_283247_, p_283017_);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283430_, (float)p_281729_).setUv(p_283247_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283430_, (float)p_281729_).setUv(p_282598_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283615_, (float)p_281729_).setUv(p_282598_, p_283017_);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public void innerBlitCustomShader2(int textureID, PoseStack pose, int p_281399_, int p_283222_, int p_283615_, int p_283430_, int p_281729_, float p_283247_, float p_282598_, float p_282883_, float p_283017_) {
        RenderSystem._setShaderTexture((int)0, (int)textureID);
        RenderSystem.setShader(() -> PlayerStatusManagerClient.positionTexBlur);
        if (PlayerStatusManagerClient.positionTexBlur == null) {
            return;
        }
        if (PlayerStatusManagerClient.positionTexBlur.RESOLUTION != null) {
            int sizeX = ScreenParticleRenderer.getInstance().widthScaledDown;
            int sizeY = ScreenParticleRenderer.getInstance().heightScaledDown;
            PlayerStatusManagerClient.positionTexBlur.RESOLUTION.set((float)sizeX, (float)sizeY);
        }
        if (PlayerStatusManagerClient.positionTexBlur.RADIUS != null) {
            PlayerStatusManagerClient.positionTexBlur.RADIUS.set(0.0f);
        }
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283615_, (float)p_281729_).setUv(p_283247_, p_283017_);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283430_, (float)p_281729_).setUv(p_283247_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283430_, (float)p_281729_).setUv(p_282598_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283615_, (float)p_281729_).setUv(p_282598_, p_283017_);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public void innerBlitCustomShaderHorizontal(PoseStack pose, int p_281399_, int p_283222_, int p_283615_, int p_283430_, int p_281729_, float p_283247_, float p_282598_, float p_282883_, float p_283017_) {
        if (RenderHelper.xaeroWorldMapTextureID != -1) {
            GlStateManager._bindTexture((int)RenderHelper.xaeroWorldMapTextureID);
            RenderSystem.setShaderTexture((int)0, (int)RenderHelper.xaeroWorldMapTextureID);
        } else {
            RenderSystem._setShaderTexture((int)0, (int)this.mainRenderTarget.getColorTextureId());
        }
        RenderSystem.setShader(() -> PlayerStatusManagerClient.positionTexBlurHorizontal);
        if (PlayerStatusManagerClient.positionTexBlurHorizontal == null) {
            return;
        }
        if (PlayerStatusManagerClient.positionTexBlurHorizontal.BLUR_LEVEL != null) {
            PlayerStatusManagerClient.positionTexBlurHorizontal.BLUR_LEVEL.set((float)(RenderHelper.xaeroWorldMapTextureID != -1 ? 0 : ConfigServerControlledSyncedToClient.dynamicGuiBlurLevel));
        }
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        if (RenderHelper.xaeroWorldMapTextureID != -1) {
            bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283615_, (float)p_281729_).setUv(p_283247_, p_282883_);
            bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283430_, (float)p_281729_).setUv(p_283247_, p_283017_);
            bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283430_, (float)p_281729_).setUv(p_282598_, p_283017_);
            bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283615_, (float)p_281729_).setUv(p_282598_, p_282883_);
        } else {
            bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283615_, (float)p_281729_).setUv(p_283247_, p_283017_);
            bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283430_, (float)p_281729_).setUv(p_283247_, p_282883_);
            bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283430_, (float)p_281729_).setUv(p_282598_, p_282883_);
            bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283615_, (float)p_281729_).setUv(p_282598_, p_283017_);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public void innerBlitCustomShaderVertical(PoseStack pose, int p_281399_, int p_283222_, int p_283615_, int p_283430_, int p_281729_, float p_283247_, float p_282598_, float p_282883_, float p_283017_) {
        RenderSystem._setShaderTexture((int)0, (int)this.mainRenderTargetScaledDown.getColorTextureId());
        RenderSystem.setShader(() -> PlayerStatusManagerClient.positionTexBlurVertical);
        if (PlayerStatusManagerClient.positionTexBlurVertical == null) {
            return;
        }
        if (PlayerStatusManagerClient.positionTexBlurVertical.RESOLUTION != null) {
            int sizeX = ScreenParticleRenderer.getInstance().widthScaledDown;
            int sizeY = ScreenParticleRenderer.getInstance().heightScaledDown;
            PlayerStatusManagerClient.positionTexBlurVertical.RESOLUTION.set((float)sizeX, (float)sizeY);
        }
        if (PlayerStatusManagerClient.positionTexBlurVertical.RADIUS != null) {
            PlayerStatusManagerClient.positionTexBlurVertical.RADIUS.set((float)ConfigServerControlledSyncedToClient.dynamicGuiSizeRadiusInPixelsToShow);
        }
        if (PlayerStatusManagerClient.positionTexBlurVertical.BLUR_LEVEL != null) {
            PlayerStatusManagerClient.positionTexBlurVertical.BLUR_LEVEL.set((float)ConfigServerControlledSyncedToClient.dynamicGuiBlurLevel);
        }
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283615_, (float)p_281729_).setUv(p_283247_, p_283017_);
        bufferbuilder.addVertex(matrix4f, (float)p_281399_, (float)p_283430_, (float)p_281729_).setUv(p_283247_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283430_, (float)p_281729_).setUv(p_282598_, p_282883_);
        bufferbuilder.addVertex(matrix4f, (float)p_283222_, (float)p_283615_, (float)p_281729_).setUv(p_282598_, p_283017_);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public void innerBlit(PoseStack pose, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
    }
}

