/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.ApiStatus;

public class RayTraceUtils {
    public static final BlockState BLOCK_STATE_AIR = Blocks.AIR.defaultBlockState();
    public static final BlockStatePredicate BLOCK_FILTER_ANY = state -> true;
    public static final BlockStatePredicate BLOCK_FILTER_NON_AIR = state -> state.getBlock().defaultBlockState() != BLOCK_STATE_AIR;

    public static HitResult getRayTraceFromEntity(Level world, Entity entity, ClipContext.Fluid fluidHandling) {
        double d;
        if (entity instanceof Player) {
            Player pe = (Player)entity;
            d = pe.blockInteractionRange() + 1.0;
        } else {
            d = 5.0;
        }
        return RayTraceUtils.getRayTraceFromEntity(world, entity, fluidHandling, true, d);
    }

    public static HitResult getRayTraceFromEntity(Level world, Entity entity, ClipContext.Fluid fluidHandling, boolean includeEntities, double maxRange) {
        Vec3 eyesPos = entity.getEyePosition();
        Vec3 rangedLook = MathUtils.scale(MathUtils.getRotationVector(entity.getYRot(), entity.getXRot()), maxRange);
        Vec3 lookEndPos = eyesPos.add(rangedLook);
        ClipContext context = new ClipContext(eyesPos, lookEndPos, ClipContext.Block.COLLIDER, fluidHandling, entity);
        BlockHitResult result = world.clip(context);
        if (includeEntities) {
            AABB bb = entity.getBoundingBox().inflate(rangedLook.x, rangedLook.y, rangedLook.z).inflate(1.0, 1.0, 1.0);
            List list = world.getEntities(entity, bb);
            double closest = result != null && result.getType() == HitResult.Type.BLOCK ? eyesPos.distanceToSqr(result.getLocation()) : Double.MAX_VALUE;
            EntityHitResult entityTrace = null;
            Entity targetEntity = null;
            for (Entity entityTmp : list) {
                EntityHitResult traceTmp;
                double distance;
                bb = entityTmp.getBoundingBox();
                Optional opt = bb.clip(eyesPos, lookEndPos);
                if (!opt.isPresent() || !((distance = eyesPos.distanceToSqr((traceTmp = new EntityHitResult(entityTmp, (Vec3)opt.get())).getLocation())) < closest)) continue;
                targetEntity = entityTmp;
                entityTrace = traceTmp;
                closest = distance;
            }
            if (targetEntity != null) {
                result = new EntityHitResult(targetEntity, entityTrace.getLocation());
            }
        }
        if (result == null || eyesPos.distanceTo(result.getLocation()) > maxRange) {
            result = null;
        }
        return result;
    }

    @Nullable
    @ApiStatus.Experimental
    public static HitResult rayTraceBlocks(Level world, Vec3 start, Vec3 end, RayTraceFluidHandling fluidMode, boolean ignoreNonCollidable, boolean returnLastUncollidableBlock, @Nullable LayerRange layerRange, int maxSteps) {
        return RayTraceUtils.rayTraceBlocks(world, start, end, RayTraceCalculationData::checkRayCollision, fluidMode, BLOCK_FILTER_ANY, ignoreNonCollidable, returnLastUncollidableBlock, layerRange, maxSteps);
    }

    @Nullable
    @ApiStatus.Experimental
    public static HitResult rayTraceBlocks(Level world, Vec3 start, Vec3 end, IRayPositionHandler handler, RayTraceFluidHandling fluidMode, BlockStatePredicate blockFilter, boolean ignoreNonCollidable, boolean returnLastUncollidableBlock, @Nullable LayerRange layerRange, int maxSteps) {
        if (Double.isNaN(start.x) || Double.isNaN(start.y) || Double.isNaN(start.z) || Double.isNaN(end.x) || Double.isNaN(end.y) || Double.isNaN(end.z)) {
            return null;
        }
        RayTraceCalculationData data = new RayTraceCalculationData(start, end, fluidMode, blockFilter, layerRange);
        while (--maxSteps >= 0) {
            if (handler.handleRayTracePosition(data, world, ignoreNonCollidable)) {
                return data.trace;
            }
            if (!RayTraceUtils.rayTraceAdvance(data)) continue;
        }
        if (returnLastUncollidableBlock) {
            Vec3 pos = new Vec3(data.currentX, data.currentY, data.currentZ);
            return BlockHitResult.miss((Vec3)pos, (Direction)data.facing, (BlockPos)data.mutablePos.immutable());
        }
        return null;
    }

    @ApiStatus.Experimental
    public static boolean checkRayCollision(RayTraceCalculationData data, Level world, boolean ignoreNonCollidable) {
        BlockHitResult traceTmp;
        BlockState state;
        if (data.isPositionWithinRange() && data.isValidBlock(state = world.getBlockState((BlockPos)data.mutablePos)) && (!ignoreNonCollidable && state.getBlock().defaultBlockState() != BLOCK_STATE_AIR || state.getCollisionShape((BlockGetter)world, (BlockPos)data.mutablePos) != Shapes.empty()) && (state.getProperties().contains(BlockStateProperties.WATERLOGGED) || data.fluidMode.handled(state)) && (traceTmp = state.getInteractionShape((BlockGetter)world, data.mutablePos.immutable()).clip(data.start, data.end, data.mutablePos.immutable())) != null) {
            data.trace = traceTmp;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public static boolean rayTraceAdvance(RayTraceCalculationData data) {
        boolean hasDistToEndX = true;
        boolean hasDistToEndY = true;
        boolean hasDistToEndZ = true;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        if (Double.isNaN(data.currentX) || Double.isNaN(data.currentY) || Double.isNaN(data.currentZ)) {
            data.trace = null;
            return true;
        }
        if (data.blockX == data.endBlockX && data.blockY == data.endBlockY && data.blockZ == data.endBlockZ) {
            return true;
        }
        if (data.endBlockX > data.blockX) {
            nextX = (double)data.blockX + 1.0;
        } else if (data.endBlockX < data.blockX) {
            nextX = (double)data.blockX + 0.0;
        } else {
            hasDistToEndX = false;
        }
        if (data.endBlockY > data.blockY) {
            nextY = (double)data.blockY + 1.0;
        } else if (data.endBlockY < data.blockY) {
            nextY = (double)data.blockY + 0.0;
        } else {
            hasDistToEndY = false;
        }
        if (data.endBlockZ > data.blockZ) {
            nextZ = (double)data.blockZ + 1.0;
        } else if (data.endBlockZ < data.blockZ) {
            nextZ = (double)data.blockZ + 0.0;
        } else {
            hasDistToEndZ = false;
        }
        double relStepX = 999.0;
        double relStepY = 999.0;
        double relStepZ = 999.0;
        double distToEndX = data.end.x - data.currentX;
        double distToEndY = data.end.y - data.currentY;
        double distToEndZ = data.end.z - data.currentZ;
        if (hasDistToEndX) {
            relStepX = (nextX - data.currentX) / distToEndX;
        }
        if (hasDistToEndY) {
            relStepY = (nextY - data.currentY) / distToEndY;
        }
        if (hasDistToEndZ) {
            relStepZ = (nextZ - data.currentZ) / distToEndZ;
        }
        if (relStepX == -0.0) {
            relStepX = -1.0E-4;
        }
        if (relStepY == -0.0) {
            relStepY = -1.0E-4;
        }
        if (relStepZ == -0.0) {
            relStepZ = -1.0E-4;
        }
        if (relStepX < relStepY && relStepX < relStepZ) {
            data.facing = data.endBlockX > data.blockX ? Direction.WEST : Direction.EAST;
            data.currentX = nextX;
            data.currentY += distToEndY * relStepX;
            data.currentZ += distToEndZ * relStepX;
        } else if (relStepY < relStepZ) {
            data.facing = data.endBlockY > data.blockY ? Direction.DOWN : Direction.UP;
            data.currentX += distToEndX * relStepY;
            data.currentY = nextY;
            data.currentZ += distToEndZ * relStepY;
        } else {
            data.facing = data.endBlockZ > data.blockZ ? Direction.NORTH : Direction.SOUTH;
            data.currentX += distToEndX * relStepZ;
            data.currentY += distToEndY * relStepZ;
            data.currentZ = nextZ;
        }
        int x = MathUtils.floor(data.currentX) - (data.facing == Direction.EAST ? 1 : 0);
        int y = MathUtils.floor(data.currentY) - (data.facing == Direction.UP ? 1 : 0);
        int z = MathUtils.floor(data.currentZ) - (data.facing == Direction.SOUTH ? 1 : 0);
        data.setBlockPos(x, y, z);
        return false;
    }

    @ApiStatus.Experimental
    public static interface IRayPositionHandler {
        public boolean handleRayTracePosition(RayTraceCalculationData var1, Level var2, boolean var3);
    }

    @ApiStatus.Experimental
    public static interface BlockStatePredicate {
        public boolean test(BlockState var1);
    }

    @ApiStatus.Experimental
    public static enum RayTraceFluidHandling {
        NONE(blockState -> !BlockUtils.isFluidBlock(blockState)),
        SOURCE_ONLY(BlockUtils::isFluidSourceBlock),
        ANY(BlockUtils::isFluidBlock);

        private final BlockStatePredicate predicate;

        private RayTraceFluidHandling(BlockStatePredicate predicate) {
            this.predicate = predicate;
        }

        public boolean handled(BlockState blockState) {
            return this.predicate.test(blockState);
        }
    }

    @ApiStatus.Experimental
    public static class RayTraceCalculationData {
        @Nullable
        protected final LayerRange range;
        public final RayTraceFluidHandling fluidMode;
        public final BlockStatePredicate blockFilter;
        public final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        public final Vec3 start;
        public final Vec3 end;
        public final int endBlockX;
        public final int endBlockY;
        public final int endBlockZ;
        public int blockX;
        public int blockY;
        public int blockZ;
        public double currentX;
        public double currentY;
        public double currentZ;
        public Direction facing;
        @Nullable
        public HitResult trace;

        public RayTraceCalculationData(Vec3 start, Vec3 end, RayTraceFluidHandling fluidMode, BlockStatePredicate blockFilter, @Nullable LayerRange range) {
            this.start = start;
            this.end = end;
            this.fluidMode = fluidMode;
            this.blockFilter = blockFilter;
            this.range = range;
            this.currentX = start.x;
            this.currentY = start.y;
            this.currentZ = start.z;
            this.endBlockX = MathUtils.floor(end.x);
            this.endBlockY = MathUtils.floor(end.y);
            this.endBlockZ = MathUtils.floor(end.z);
            this.setBlockPos(MathUtils.floor(start.x), MathUtils.floor(start.y), MathUtils.floor(start.z));
        }

        public void setBlockPos(int x, int y, int z) {
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.mutablePos.set(this.blockX, this.blockY, this.blockZ);
        }

        public boolean isValidBlock(BlockState state) {
            return this.blockFilter.test(state);
        }

        public boolean isPositionWithinRange() {
            return this.range == null || this.range.isPositionWithinRange(this.blockX, this.blockY, this.blockZ);
        }

        public boolean checkRayCollision(Level world, boolean ignoreNonCollidable) {
            BlockHitResult traceTmp;
            if (!this.isPositionWithinRange()) {
                return false;
            }
            BlockState state = world.getBlockState((BlockPos)this.mutablePos);
            if (state == BLOCK_STATE_AIR || !this.isValidBlock(state) || !ignoreNonCollidable && state.getCollisionShape((BlockGetter)world, (BlockPos)this.mutablePos) == Shapes.empty()) {
                return false;
            }
            if ((state.getProperties().contains(BlockStateProperties.WATERLOGGED) || this.fluidMode.handled(state)) && (traceTmp = state.getInteractionShape((BlockGetter)world, (BlockPos)this.mutablePos).clip(this.start, this.end, (BlockPos)this.mutablePos)) != null) {
                this.trace = traceTmp;
                return true;
            }
            return false;
        }
    }
}

