/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.RepeatCtmProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RepeatSpriteProvider
implements SpriteProvider {
    protected TextureAtlasSprite[] sprites;
    protected int width;
    protected int height;
    protected Symmetry symmetry;
    protected OrientationMode orientationMode;

    public RepeatSpriteProvider(TextureAtlasSprite[] sprites, int width, int height, Symmetry symmetry, OrientationMode orientationMode) {
        this.sprites = sprites;
        this.width = width;
        this.height = height;
        this.symmetry = symmetry;
        this.orientationMode = orientationMode;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getSprite(QuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, ProcessingDataProvider dataProvider) {
        int spriteX;
        Direction face = this.symmetry.apply(quad.lightFace());
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int spriteY = switch (face) {
            case Direction.DOWN -> {
                spriteX = x;
                yield -z - 1;
            }
            case Direction.UP -> {
                spriteX = x;
                yield z;
            }
            case Direction.NORTH -> {
                spriteX = -x - 1;
                yield -y;
            }
            case Direction.SOUTH -> {
                spriteX = x;
                yield -y;
            }
            case Direction.WEST -> {
                spriteX = z;
                yield -y;
            }
            case Direction.EAST -> {
                spriteX = -z - 1;
                yield -y;
            }
            default -> {
                spriteX = 0;
                yield 0;
            }
        };
        switch (this.orientationMode.getOrientation(quad, appearanceState)) {
            case 1: {
                int temp = spriteX;
                spriteX = -spriteY - 1;
                spriteY = temp;
                break;
            }
            case 2: {
                spriteX = -spriteX - 1;
                spriteY = -spriteY - 1;
                break;
            }
            case 3: {
                int temp = spriteX;
                spriteX = spriteY;
                spriteY = -temp - 1;
                break;
            }
            case 4: {
                int temp = spriteX;
                spriteX = spriteY;
                spriteY = temp;
                break;
            }
            case 5: {
                spriteY = -spriteY - 1;
                break;
            }
            case 6: {
                int temp = spriteX;
                spriteX = -spriteY - 1;
                spriteY = -temp - 1;
                break;
            }
            case 7: {
                spriteX = -spriteX - 1;
            }
        }
        if ((spriteX %= this.width) < 0) {
            spriteX += this.width;
        }
        if ((spriteY %= this.height) < 0) {
            spriteY += this.height;
        }
        return this.sprites[this.width * spriteY + spriteX];
    }

    public static class Factory
    implements SpriteProvider.Factory<RepeatCtmProperties> {
        @Override
        public SpriteProvider createSpriteProvider(TextureAtlasSprite[] sprites, RepeatCtmProperties properties) {
            return new RepeatSpriteProvider(sprites, properties.getWidth(), properties.getHeight(), properties.getSymmetry(), properties.getOrientationMode());
        }

        @Override
        public int getTextureAmount(RepeatCtmProperties properties) {
            return properties.getWidth() * properties.getHeight();
        }
    }
}

