/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.player.config.dynamic;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;

public final class PlayerConfigDynamicOptions {
    private final Map<String, IPlayerConfigOptionSpecAPI<?>> options;

    private PlayerConfigDynamicOptions(Map<String, IPlayerConfigOptionSpecAPI<?>> options) {
        this.options = options;
    }

    public Map<String, IPlayerConfigOptionSpecAPI<?>> getOptions() {
        return this.options;
    }

    public static final class Builder {
        private Map<String, IPlayerConfigOptionSpecAPI<?>> options = new LinkedHashMap();

        private Builder() {
        }

        public Builder setDefault() {
            this.options.clear();
            return this;
        }

        public Builder addOption(PlayerConfigOptionSpec<?> option) {
            if (!option.isDynamic()) {
                throw new IllegalArgumentException("tried to add a static option to dynamic options!");
            }
            this.options.put(option.getId(), option);
            return this;
        }

        public PlayerConfigDynamicOptions build() {
            return new PlayerConfigDynamicOptions(Collections.unmodifiableMap(this.options));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

