/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.client.init.v1.ItemModelDisplayOverrides;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;

public abstract class ItemDisplayOverridesImpl<T>
implements ItemModelDisplayOverrides {
    private final Map<ModelResourceLocation, Map<ItemDisplayContext, Function<BakedModelResolver, BakedModel>>> overrideLocations = new HashMap<ModelResourceLocation, Map<ItemDisplayContext, Function<BakedModelResolver, BakedModel>>>();

    protected ItemDisplayOverridesImpl() {
        this.registerEventHandlers();
    }

    @Override
    public void register(ModelResourceLocation itemModel, ModelResourceLocation itemModelOverride) {
        this.register(itemModel, itemModelOverride, ItemDisplayOverridesImpl.getVanillaItemModelDisplayOverrides());
    }

    @Override
    public void register(ModelResourceLocation itemModel, ResourceLocation itemModelOverride) {
        this.register(itemModel, itemModelOverride, ItemDisplayOverridesImpl.getVanillaItemModelDisplayOverrides());
    }

    static ItemDisplayContext[] getVanillaItemModelDisplayOverrides() {
        return (ItemDisplayContext[])EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(ItemDisplayContext.GUI, ItemDisplayContext.GROUND, ItemDisplayContext.FIXED), ItemDisplayContext.class)).toArray(ItemDisplayContext[]::new);
    }

    protected void register(ModelResourceLocation modelResourceLocation, Function<BakedModelResolver, BakedModel> bakedModelGetter, ItemDisplayContext[] itemDisplayContexts) {
        Objects.requireNonNull(modelResourceLocation, "item model is null");
        Preconditions.checkState((itemDisplayContexts.length > 0 ? 1 : 0) != 0, (Object)"item display contexts is empty");
        Map overrides = this.overrideLocations.computeIfAbsent(modelResourceLocation, $ -> new EnumMap(ItemDisplayContext.class));
        for (ItemDisplayContext itemDisplayContext : itemDisplayContexts) {
            if (overrides.put(itemDisplayContext, bakedModelGetter) == null) continue;
            throw new IllegalStateException("Attempting to register duplicate item model display override for model %s and display context %s".formatted(modelResourceLocation, itemDisplayContext));
        }
    }

    protected Map<T, Map<ItemDisplayContext, BakedModel>> computeOverrideModels(BakedModelResolver modelResolver, BakedModel missingModel) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ModelResourceLocation, Map<ItemDisplayContext, Function<BakedModelResolver, BakedModel>>> overrideEntry : this.overrideLocations.entrySet()) {
            BakedModel itemModel = modelResolver.getModel(overrideEntry.getKey());
            Preconditions.checkState((itemModel != missingModel ? 1 : 0) != 0, (Object)"item model is missing");
            ImmutableMap.Builder overrideBuilder = ImmutableMap.builder();
            for (Map.Entry<ItemDisplayContext, Function<BakedModelResolver, BakedModel>> entry : overrideEntry.getValue().entrySet()) {
                BakedModel overrideModel = (BakedModel)entry.getValue().apply((Object)modelResolver);
                Preconditions.checkState((overrideModel != missingModel ? 1 : 0) != 0, (Object)"override model is missing");
                overrideBuilder.put((Object)entry.getKey(), (Object)overrideModel);
            }
            T overrideModelKey = this.createOverrideModelKey(overrideEntry.getKey(), itemModel);
            builder.put(overrideModelKey, (Object)overrideBuilder.build());
        }
        return builder.build();
    }

    protected abstract T createOverrideModelKey(ModelResourceLocation var1, BakedModel var2);

    protected abstract void registerEventHandlers();

    protected static interface BakedModelResolver {
        public BakedModel getModel(ModelResourceLocation var1);

        public BakedModel getModel(ResourceLocation var1);
    }
}

