/*
 * Decompiled with CFR 0.152.
 */
package com.argos.elitex.registeration;

import com.argos.elitex.registeration.ModItemRegistry;
import com.tacz.guns.init.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EliteXCreativeTabRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"elitex");
    public static final Supplier<CreativeModeTab> ELITE_X_CREATIVE_TAB = CREATIVE_MODE_TABS.register("elitex", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItemRegistry.CREATIVE_ICON.get())).title((Component)Component.translatable((String)"creative_tab.elitex")).displayItems((parameters, output) -> {
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:colt_m1911x1", 7, "SEMI", true, "elitex.gun.colt_m1911x1.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:jrx", 20, "SEMI", true, "elitex.gun.jrx.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:five_seven", 20, "SEMI", true, "elitex.gun.five_seven.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:srz_2011", 16, "SEMI", true, "elitex.gun.srz_2011.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:bo1_1911", 8, "SEMI", true, "elitex.gun.bo1_1911.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:op1911", 7, "SEMI", true, "elitex.gun.op1911.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:springfield_m1911", 7, "SEMI", true, "elitex.gun.springfield_m1911.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:raygun_bo6", 20, "AUTO", false, "elitex.gun.raygun_bo6.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:trs_bull", 5, "SEMI", false, "elitex.gun.trs_bull.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:ro635v3", 32, "AUTO", true, "elitex.gun.ro635v3.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:mp5_classic", 30, "AUTO", true, "elitex.gun.mp5_classic.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:vector45acp", 35, "AUTO", true, "elitex.gun.vector45acp.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:ak47x", 30, "AUTO", true, "elitex.gun.ak47x.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:m4_sopmod", 35, "AUTO", true, "elitex.gun.m4_sopmod.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:mcs_spear", 20, "AUTO", true, "elitex.gun.mcs_spear.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:famas_f1", 25, "AUTO", true, "elitex.gun.famas_f1.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:akx105", 30, "AUTO", true, "elitex.gun.akx105.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:fh_scar18", 20, "SEMI", true, "elitex.gun.fh_scar18.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:fs_scar19", 30, "AUTO", true, "elitex.gun.fs_scar19.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:m4a1_classic", 30, "AUTO", true, "elitex.gun.m4a1_classic.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:m16", 30, "BURST", true, "elitex.gun.m16.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:golden_ak", 30, "AUTO", true, "elitex.gun.golden_ak.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:sassy_dmr", 20, "SEMI", true, "elitex.gun.sassy_dmr.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:ray_gun_mk2", 21, "BURST", true, "elitex.gun.ray_gun_mk2.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:wonder_waffle", 3, "SEMI", true, "elitex.gun.wonder_waffle.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:mustang_and_sally", 12, "SEMI", true, "elitex.gun.mustang_and_sally.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:origin_electric_staff", 9, "SEMI", false, "elitex.gun.origin_electric_staff.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:origin_fire_staff", 10, "SEMI", false, "elitex.gun.origin_fire_staff.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:origin_ice_staff", 10, "SEMI", false, "elitex.gun.origin_ice_staff.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:origin_wind_staff", 10, "SEMI", false, "elitex.gun.origin_wind_staff.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:benelli_super", 8, "SEMI", true, "elitex.gun.benelli_super.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:spaz12", 8, "SEMI", true, "elitex.gun.spaz12.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:kar98k", 5, "SEMI", false, "elitex.gun.kar98k.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:m1_garand", 8, "SEMI", false, "elitex.gun.m1_garand.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:lee", 10, "SEMI", false, "elitex.gun.lee.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:sp_m1903", 5, "SEMI", false, "elitex.gun.sp_m1903.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:inter_m200", 7, "SEMI", true, "elitex.gun.inter_m200.name"));
        output.accept(EliteXCreativeTabRegistry.createCustomNBTItem(ModItems.MODERN_KINETIC_GUN, "elitex:m249x", 150, "AUTO", false, "elitex.gun.m249x.name"));
    }).build());

    private static ItemStack createCustomNBTItem(Object baseItem, String gunId, int ammoCount, String fireMode, boolean hasBulletInBarrel, String displayName) {
        Item item;
        if (baseItem instanceof Item) {
            item = (Item)baseItem;
        } else {
            try {
                item = ((ItemLike)baseItem).asItem();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert baseItem to Item type");
            }
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = new CompoundTag();
        tag.putString("GunId", gunId);
        tag.putInt("GunCurrentAmmoCount", ammoCount);
        tag.putString("GunFireMode", fireMode);
        tag.putByte("HasBulletInBarrel", (byte)(hasBulletInBarrel ? 1 : 0));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)displayName).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        return stack;
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }
}

