/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block.entity;

import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InfuserBlockEntity
extends EnchantingTableBlockEntity
implements WorldlyContainer,
TickingBlockEntity,
ListBackedContainer {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private LockCode code = LockCode.NO_LOCK;

    public InfuserBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.value();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.code = LockCode.fromTag((CompoundTag)tag);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.code.addToTag(tag);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (index == 0) {
            return this.getItem(0).isEmpty();
        }
        return false;
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemStack, Direction direction) {
        return index == 0 && (itemStack.isEnchanted() || itemStack.getItem() instanceof EnchantedBookItem);
    }

    public boolean canOpen(Player player) {
        return BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)this.code, (Component)this.getDisplayName());
    }

    public void clientTick() {
        InfuserBlockEntity.bookAnimationTick((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState(), (EnchantingTableBlockEntity)this);
    }
}

