/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import org.sinytra.adapter.patch.ClassPatchInstance;
import org.sinytra.adapter.patch.InterfacePatchInstance;
import org.sinytra.adapter.patch.api.Patch;

public class PatchSerialization {
    private static final BiMap<String, Codec<? extends Patch>> PATCH_INSTANCE_CODECS = ImmutableBiMap.builder().put((Object)"class", ClassPatchInstance.CODEC).put((Object)"interface", InterfacePatchInstance.CODEC).build();
    public static final Codec<Patch> PATCH_INSTANCE_CODEC = Codec.STRING.partialDispatch("type", transform -> DataResult.success((Object)PatchSerialization.getPatchInstanceName(transform)), name -> {
        Codec entryCodec = (Codec)PATCH_INSTANCE_CODECS.get(name);
        if (entryCodec != null) {
            return DataResult.success((Object)entryCodec.fieldOf("patch"));
        }
        return DataResult.error(() -> "Missing codec for patch instance " + name);
    });

    private static String getPatchInstanceName(Patch instance) {
        return Objects.requireNonNull((String)PATCH_INSTANCE_CODECS.inverse().get(instance.codec()), "Missing name for patch instance " + String.valueOf(instance));
    }

    public static <T> T serialize(List<Patch> patches, DynamicOps<T> dynamicOps) {
        DataResult result = PATCH_INSTANCE_CODEC.listOf().encodeStart(dynamicOps, patches);
        return (T)result.getOrThrow(s -> {
            throw new RuntimeException("Error serializing patches: " + s);
        });
    }

    public static <T> List<Patch> deserialize(T patches, DynamicOps<T> dynamicOps) {
        return (List)((Pair)PATCH_INSTANCE_CODEC.listOf().decode(dynamicOps, patches).getOrThrow(s -> {
            throw new RuntimeException("Error deserializing patches: " + s);
        })).getFirst();
    }
}

