/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResult;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.patch.analysis.InsnComparator;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class InjectionTargetResolver
implements Resolver {
    private static final int INSN_RANGE = 5;
    private final List<Resolver> subResolvers = new ArrayList<Resolver>();

    public void addSubResolver(Resolver subResolver) {
        this.subResolvers.add(subResolver);
    }

    @Override
    public TxResult resolve(MixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        if (dirty.getAtData() != null) {
            return TxResult.PASS;
        }
        MethodQualifier dirtyQualifier = dirty.getTargetMethod();
        if (dirtyQualifier == null) {
            return TxResult.FAIL;
        }
        MethodContext.TargetPair pair = context.methods().findOwnMethodPair(context.dirtyLookup(), dirtyQualifier);
        if (pair == null) {
            return TxResult.FAIL;
        }
        List<AbstractInsnNode> insns = context.methods().findInjectionTargetInsns(pair);
        if (!insns.isEmpty()) {
            dirty.inheritAtData();
            return TxResult.SUCCESS;
        }
        for (Resolver subResolver : this.subResolvers) {
            TxResult result = subResolver.resolve(mixin, context, clean, dirty, recipe);
            if (result == TxResult.PASS) continue;
            return result;
        }
        if (!clean.getAtData().getValue().equals("INVOKE")) {
            dirty.inheritAtData();
            return TxResult.SUCCESS;
        }
        if (InjectionTargetResolver.findReplacedType(context, clean.getTargetMethod(), pair.methodNode(), clean.getAtData(), dirty)) {
            return TxResult.SUCCESS;
        }
        return TxResult.FAIL;
    }

    private static boolean findReplacedType(MixinContext context, MethodQualifier cleanQualifier, MethodNode dirtyMethod, AtData original, MutableConfiguration dirty) {
        AbstractInsnNode abstractInsnNode;
        MethodContext.TargetPair cleanPair = context.methods().findOwnMethodPair(context.cleanLookup(), cleanQualifier);
        List<AbstractInsnNode> insns = context.methods().findInjectionTargetInsns(cleanPair);
        if (insns.isEmpty() || !((abstractInsnNode = insns.getFirst()) instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode cleanInsn = (MethodInsnNode)abstractInsnNode;
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findSurroundingInstructions((AbstractInsnNode)cleanInsn, 5);
        Multimap<String, MethodInsnNode> dirtyCalls = MethodCallAnalyzer.getMethodCalls(dirtyMethod, new ArrayList<String>());
        List<InstructionMatcher> dirtyMatchers = dirtyCalls.values().stream().map(i -> MethodCallAnalyzer.findSurroundingInstructions((AbstractInsnNode)i, 5)).toList();
        MethodInsnNode replacement = InjectionTargetResolver.findBestMatch(context, cleanInsn, cleanMatcher, dirtyMatchers);
        if (replacement != null) {
            String target = MethodQualifier.create(replacement).asDescriptor();
            dirty.setAtData(original.withTarget(target));
            return true;
        }
        return false;
    }

    private static MethodInsnNode findBestMatch(MixinContext context, MethodInsnNode cleanInsn, InstructionMatcher cleanMatcher, List<InstructionMatcher> dirtyMatchers) {
        HashMultimap matches = HashMultimap.create();
        for (InstructionMatcher m : dirtyMatchers) {
            boolean before = cleanMatcher.testBefore(m);
            boolean after = cleanMatcher.testAfter(m);
            int priority = before && after ? 2 : (before || after ? 1 : 0);
            MethodInsnNode dirtyInsn = (MethodInsnNode)m.insn();
            if (priority <= 0 || !InjectionTargetResolver.matchesMethodCall(context, cleanInsn, dirtyInsn)) continue;
            matches.put((Object)priority, (Object)dirtyInsn);
        }
        for (int i = 2; i > 0; --i) {
            if (!matches.containsKey((Object)i)) continue;
            return matches.get((Object)i).size() == 1 || AdapterUtil.allElementsEqual(matches.get((Object)i), InsnComparator::insnEqual) ? (MethodInsnNode)matches.get((Object)i).iterator().next() : null;
        }
        return null;
    }

    private static boolean matchesMethodCall(MixinContext context, MethodInsnNode cleanInsn, MethodInsnNode dirtyInsn) {
        return cleanInsn.owner.equals(dirtyInsn.owner) && cleanInsn.name.equals(dirtyInsn.name) || context.getTypeAdapter(Type.getObjectType((String)dirtyInsn.owner), Type.getObjectType((String)cleanInsn.owner)) != null && Type.getArgumentTypes((String)cleanInsn.desc).length == Type.getArgumentTypes((String)dirtyInsn.desc).length;
    }
}

