/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.config;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.caffeinemc.mods.lithium.common.config.LithiumConfig;
import org.apache.logging.log4j.Logger;

public class Option {
    private final String name;
    private Object2BooleanLinkedOpenHashMap<Option> dependencies;
    private Set<String> modDefined = null;
    private boolean enabled;
    private boolean userDefined;

    public Option(String name, boolean enabled, boolean userDefined) {
        this.name = name;
        this.enabled = enabled;
        this.userDefined = userDefined;
    }

    public void setEnabled(boolean enabled, boolean userDefined) {
        this.enabled = enabled;
        this.userDefined = userDefined;
    }

    public void addModOverride(boolean enabled, String modId) {
        this.enabled = enabled;
        if (this.modDefined == null) {
            this.modDefined = new LinkedHashSet<String>();
        }
        this.modDefined.add(modId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledRecursive(LithiumConfig config) {
        return this.enabled && (config.getParent(this) == null || config.getParent(this).isEnabledRecursive(config));
    }

    public boolean isOverridden() {
        return this.isUserDefined() || this.isModDefined();
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public boolean isModDefined() {
        return this.modDefined != null;
    }

    public String getName() {
        return this.name;
    }

    public void clearModsDefiningValue() {
        this.modDefined = null;
    }

    public Collection<String> getDefiningMods() {
        return this.modDefined != null ? Collections.unmodifiableCollection(this.modDefined) : Collections.emptyList();
    }

    public void addDependency(Option dependencyOption, boolean requiredValue) {
        if (this.dependencies == null) {
            this.dependencies = new Object2BooleanLinkedOpenHashMap(1);
        }
        this.dependencies.put((Object)dependencyOption, requiredValue);
    }

    public boolean disableIfDependenciesNotMet(Logger logger, LithiumConfig config) {
        if (this.dependencies != null && this.isEnabled()) {
            for (Object2BooleanMap.Entry dependency : this.dependencies.object2BooleanEntrySet()) {
                Option option = (Option)dependency.getKey();
                boolean requiredValue = dependency.getBooleanValue();
                boolean enabledRecursive = option.isEnabledRecursive(config);
                if (enabledRecursive == requiredValue) continue;
                this.enabled = false;
                logger.info("Option '{}' requires '{}={}' but found '{}'. Setting '{}={}'.", (Object)this.name, (Object)option.name, (Object)requiredValue, (Object)enabledRecursive, (Object)this.name, (Object)this.enabled);
                return true;
            }
        }
        return false;
    }
}

