/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import net.minecraft.class_3532;

public final class MathUtil {
    public static final long GOLDEN_GAMMA = -7046029254386353131L;

    public static int signum(int value) {
        if (value > 0) {
            return 1;
        }
        if (value < 0) {
            return -1;
        }
        return 0;
    }

    public static int lerp(float delta, int start, int end) {
        return start + (int)(delta * (float)(end - start));
    }

    public static int lerpColor(float delta, int colorA, int colorB) {
        return MathUtil.lerp(delta, colorA >>> 24 & 0xFF, colorB >>> 24 & 0xFF) << 24 | MathUtil.lerp(delta, colorA >>> 16 & 0xFF, colorB >>> 16 & 0xFF) << 16 | MathUtil.lerp(delta, colorA >>> 8 & 0xFF, colorB >>> 8 & 0xFF) << 8 | MathUtil.lerp(delta, colorA & 0xFF, colorB & 0xFF);
    }

    public static int lerpLight(float delta, int lightA, int lightB) {
        return MathUtil.lerp(delta, lightA >>> 20 & 0xF, lightB >>> 20 & 0xF) << 20 | MathUtil.lerp(delta, lightA >>> 4 & 0xF, lightB >>> 4 & 0xF) << 4;
    }

    public static long mix64(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public static int mix32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public static int mix(int x, int y, int z, int face, int loops) {
        return MathUtil.mix32((class_3532.method_15371((int)x, (int)y, (int)z) ^ MathUtil.mix64(-7046029254386353131L * (long)(1 + face))) + -7046029254386353131L * (long)(1 + loops));
    }
}

