/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.naga;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.DynamicChain;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieLLibraryEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.util.MowzieMathUtil;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class EntityNaga
extends MowzieLLibraryEntity
implements RangedAttackMob,
Enemy,
FlyingAnimal {
    public DynamicChain dc;
    public Vec3[] mouthPos;
    public static final Animation FLAP_ANIMATION = Animation.create(25);
    public static final Animation DODGE_ANIMATION = Animation.create(10);
    public static final Animation SPIT_ANIMATION = Animation.create(50);
    public static final Animation SWOOP_ANIMATION = Animation.create(54);
    public static final Animation HURT_TO_FALL_ANIMATION = Animation.create(20);
    public static final Animation LAND_ANIMATION = Animation.create(8);
    public static final Animation GET_UP_ANIMATION = Animation.create(33);
    public static final Animation TAIL_DEMO_ANIMATION = Animation.create(80);
    public static final Animation DIE_AIR_ANIMATION = Animation.create(70);
    public static final Animation DIE_GROUND_ANIMATION = Animation.create(70);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(EntityNaga.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> BANKING = SynchedEntityData.defineId(EntityNaga.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PREV_BANKING = SynchedEntityData.defineId(EntityNaga.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static int MAX_DIST_FROM_HOME = 50;
    private final ControlledAnimation hoverAnim = new ControlledAnimation(10);
    private final ControlledAnimation flapAnim = new ControlledAnimation(10);
    public float hoverAnimFrac;
    public float prevHoverAnimFrac;
    public float flapAnimFrac;
    public float prevFlapAnimFrac;
    private boolean hasFlapSoundPlayed = false;
    public float shoulderRot;
    public float banking;
    public float prevBanking;
    public static final int ROAR_DURATION = 30;
    public int roarAnimation = 0;
    public EnumNagaMovement movement = EnumNagaMovement.GLIDING;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public static int SPIT_COOLDOWN_MAX = 120;
    public int spitCooldown = 0;
    public static int SWOOP_COOLDOWN_MAX = 90;
    public int swoopCooldown = 0;
    public float swoopTargetCorrectY;
    public float swoopTargetCorrectX;
    public static int GROUND_TIMER_MAX = 60;
    public int onGroundTimer = 0;
    public boolean interrupted = false;

    public EntityNaga(EntityType<? extends EntityNaga> type, Level world) {
        super(type, world);
        if (world.isClientSide) {
            this.dc = new DynamicChain((Entity)this);
            this.mouthPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
        this.xpReward = 10;
        this.moveControl = new NagaMoveHelper(this);
        this.lookControl = new NagaLookController(this, (Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.setPathfindingMalus(PathType.WALKABLE, -1.0f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new FlyOutOfWaterGoal(this, this));
        this.goalSelector.addGoal(5, (Goal)new WanderGoal());
        this.goalSelector.addGoal(4, (Goal)new AIFlyAroundTarget(this));
        this.goalSelector.addGoal(3, (Goal)new AIFlyTowardsTarget(this));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, 0, true, true, target -> target.blockPosition().closerThan((Vec3i)this.getRestrictCenter(), (double)this.getRestrictRadius())){

            public boolean canContinueToUse() {
                return super.canContinueToUse() && EntityNaga.this.getTarget() != null && EntityNaga.this.getTarget().blockPosition().closerThan((Vec3i)EntityNaga.this.getRestrictCenter(), (double)EntityNaga.this.getRestrictRadius()) && EntityNaga.this.getAnimation() == IAnimatedEntity.NO_ANIMATION;
            }
        });
        this.goalSelector.addGoal(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, FLAP_ANIMATION, false){

            @Override
            public void start() {
                super.start();
                EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, (float)(0.85 + (double)EntityNaga.this.random.nextFloat() * 0.2));
            }

            public void tick() {
                super.tick();
                if (EntityNaga.this.getAnimationTick() >= 4 && EntityNaga.this.getAnimationTick() <= 9) {
                    EntityNaga.this.setDeltaMovement(EntityNaga.this.getDeltaMovement().add(0.0, 0.1, 0.0));
                }
            }
        });
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityNaga>(this, DODGE_ANIMATION, false));
        this.goalSelector.addGoal(2, (Goal)new AnimationProjectileAttackAI<EntityNaga>(this, SPIT_ANIMATION, 30, null){

            @Override
            public void start() {
                super.start();
                EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ACID_CHARGE.get(), 2.0f, 1.0f);
            }

            @Override
            public void tick() {
                super.tick();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                if (EntityNaga.this.getAnimationTick() < 9) {
                    EntityNaga.this.setDeltaMovement(EntityNaga.this.getDeltaMovement().add(0.0, 0.015, 0.0));
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, SWOOP_ANIMATION, true){

            @Override
            public void start() {
                super.start();
                EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 0.7f);
            }

            public void tick() {
                super.tick();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                Vec3 v = new Vec3(0.0, 0.0, 0.0);
                int phase1Length = 15;
                int phase2Length = 21;
                LivingEntity target = EntityNaga.this.getTarget();
                if (EntityNaga.this.getAnimationTick() < phase1Length && target != null) {
                    ((EntityNaga)this.entity).lookAt((Entity)target, 100.0f, 100.0f);
                    ((EntityNaga)this.entity).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                    if (EntityNaga.this.getAnimationTick() >= 1 && EntityNaga.this.getAnimationTick() < 1 + phase1Length) {
                        float frame = (float)(EntityNaga.this.getAnimationTick() - 1) / (float)phase1Length;
                        v = v.add(new Vec3((double)1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)-1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)0.8f * Math.sin((double)frame * Math.PI * 2.0)));
                    } else if (EntityNaga.this.getAnimationTick() >= 16) {
                        if (EntityNaga.this.getAnimationTick() == 23) {
                            if (target != null) {
                                EntityNaga.this.swoopTargetCorrectY = 0.09f * (float)Math.abs(EntityNaga.this.getY() - target.getY());
                                EntityNaga.this.swoopTargetCorrectX = 0.1f * (float)Math.sqrt((EntityNaga.this.getX() - target.getX()) * (EntityNaga.this.getX() - target.getX()) + (EntityNaga.this.getZ() - target.getZ()) * (EntityNaga.this.getZ() - target.getZ()));
                                if (EntityNaga.this.swoopTargetCorrectX > 1.8f) {
                                    EntityNaga.this.swoopTargetCorrectX = 1.8f;
                                }
                                if (EntityNaga.this.swoopTargetCorrectY > 2.0f) {
                                    EntityNaga.this.swoopTargetCorrectY = 2.0f;
                                }
                            } else {
                                EntityNaga.this.swoopTargetCorrectY = 1.0f;
                                EntityNaga.this.swoopTargetCorrectX = 1.0f;
                            }
                        }
                        if (EntityNaga.this.getAnimationTick() >= 23 && EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                            float frame = (float)(EntityNaga.this.getAnimationTick() - 23) / (float)phase2Length;
                            v = v.add(new Vec3((double)EntityNaga.this.swoopTargetCorrectX * 1.4 * (1.0 - Math.exp(2.0f * (frame - 1.0f))), (double)EntityNaga.this.swoopTargetCorrectY * -1.5 * (Math.cos((double)frame * Math.PI) * (1.0 - Math.exp(7.0f * (frame - 1.0f)))), 0.0));
                            List<LivingEntity> entitiesHit = EntityNaga.this.getEntityLivingBaseNearby(4.0, 4.0, 4.0, 4.0);
                            for (LivingEntity entityHit : entitiesHit) {
                                if (entityHit instanceof EntityNaga) continue;
                                EntityNaga.this.doHurtTarget((Entity)entityHit);
                            }
                        }
                    }
                    v = v.yRot((float)Math.toRadians(-EntityNaga.this.getYRot() - 90.0f));
                    EntityNaga.this.setDeltaMovement(v.x, v.y, v.z);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    MMCommon.PROXY.playNagaSwoopSound((EntityNaga)this.entity);
                }
                if (EntityNaga.this.getAnimationTick() == 7) {
                    EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_GRUNT_3.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ROAR_1.get(), 3.0f, 1.0f);
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, this, HURT_TO_FALL_ANIMATION, true){

            public void tick() {
            }
        });
        this.goalSelector.addGoal(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, LAND_ANIMATION, true){

            @Override
            public void start() {
                super.start();
                EntityNaga.this.playSound((SoundEvent)MMSounds.MISC_GROUNDHIT_2.get(), 1.5f, 1.0f);
            }
        });
        this.goalSelector.addGoal(1, (Goal)new SimpleAnimationAI<EntityNaga>(this, GET_UP_ANIMATION, true){

            public void tick() {
                super.tick();
                if (EntityNaga.this.getAnimationTick() == 13) {
                    EntityNaga.this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 15) {
                    EntityNaga.this.setDeltaMovement(EntityNaga.this.getDeltaMovement().add(0.0, 1.6, 0.0));
                }
            }
        });
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityNaga>(this, TAIL_DEMO_ANIMATION, false));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation(this, (Mob)this, worldIn){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(false);
        flyingpathnavigator.setCanPassDoors(false);
        return flyingpathnavigator;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(BANKING, (Object)Float.valueOf(0.0f));
        builder.define(PREV_BANKING, (Object)Float.valueOf(0.0f));
    }

    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(12.0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 12.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getAnimation() != NO_ANIMATION) {
            return null;
        }
        int r = this.random.nextInt(4);
        if (r == 0) {
            this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_NAGA_ROAR.get(this.random.nextInt(4))).get(), 5.0f, 1.0f);
            this.roarAnimation = 0;
        } else if (r <= 2) {
            this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_NAGA_GROWL.get(this.random.nextInt(3))).get(), 4.0f, 1.0f);
        }
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_NAGA_GRUNT.get(this.random.nextInt(3))).get(), 2.0f, 1.0f);
        return null;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_NAGA_ROAR.get(this.random.nextInt(4))).get(), 3.0f, 1.0f);
        return null;
    }

    @Override
    public void tick() {
        this.prevMotionX = this.getDeltaMovement().x;
        this.prevMotionY = this.getDeltaMovement().y;
        this.prevMotionZ = this.getDeltaMovement().z;
        this.prevHoverAnimFrac = this.hoverAnimFrac;
        this.prevFlapAnimFrac = this.flapAnimFrac;
        super.tick();
        this.yBodyRot = this.getYRot();
        if (this.level().isClientSide()) {
            this.banking = this.getBanking();
            this.prevBanking = this.getPrevBanking();
        }
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.swoopCooldown > 0) {
            --this.swoopCooldown;
        }
        if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if (this.roarAnimation < 30) {
            ++this.roarAnimation;
        }
        if (this.getAnimation() == null) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, NO_ANIMATION);
        }
        if (this.hasEffect(MobEffects.POISON)) {
            this.removeEffectNoUpdate(MobEffects.POISON);
        }
        if (!this.level().isClientSide) {
            if (this.getTarget() != null && (double)this.targetDistance < 29.5 && this.movement != EnumNagaMovement.FALLEN && this.movement != EnumNagaMovement.FALLING) {
                this.setAttacking(true);
                if (this.getAnimation() == NO_ANIMATION && this.swoopCooldown == 0 && this.random.nextInt(80) == 0 && this.getY() - this.getTarget().getY() > 0.0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SWOOP_ANIMATION);
                    this.swoopCooldown = SWOOP_COOLDOWN_MAX;
                } else if (this.getAnimation() == NO_ANIMATION && this.spitCooldown == 0 && this.random.nextInt(80) == 0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SPIT_ANIMATION);
                    this.spitCooldown = SPIT_COOLDOWN_MAX;
                }
            } else {
                this.setAttacking(false);
            }
        }
        if (this.movement != EnumNagaMovement.FALLING && this.movement != EnumNagaMovement.FALLEN) {
            if (this.getAttacking()) {
                this.movement = EnumNagaMovement.HOVERING;
                this.hoverAnim.increaseTimer();
                if (this.getAnimation() == NO_ANIMATION && !this.level().isClientSide) {
                    List<Projectile> projectilesNearby = this.getEntitiesNearby(Projectile.class, 30.0);
                    for (Projectile a : projectilesNearby) {
                        float dot;
                        Vec3 aActualMotion = new Vec3(a.getX() - a.xo, a.getY() - a.yo, a.getZ() - a.zo);
                        if (aActualMotion.length() < 0.1 || a.tickCount <= 1 || !((double)(dot = (float)a.getDeltaMovement().normalize().dot(this.position().subtract(a.position()).normalize())) > 0.96)) continue;
                        Vec3 dodgeVec = a.getDeltaMovement().cross(new Vec3(0.0, 1.0, 0.0)).normalize().scale(1.2);
                        Vec3 newPosLeft = this.position().add(dodgeVec.scale(2.0));
                        Vec3 newPosRight = this.position().add(dodgeVec.scale(-2.0));
                        Vec3 diffLeft = newPosLeft.subtract(a.position());
                        Vec3 diffRight = newPosRight.subtract(a.position());
                        if (diffRight.dot(a.getDeltaMovement()) > diffLeft.dot(a.getDeltaMovement())) {
                            dodgeVec = dodgeVec.scale(-1.0);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(dodgeVec));
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
                    }
                }
            } else {
                this.movement = EnumNagaMovement.GLIDING;
                this.hoverAnim.decreaseTimer();
                this.flapAnim.decreaseTimer();
            }
        } else if (this.movement == EnumNagaMovement.FALLING && (this.onGround() || this.isInLava() || this.isInWater())) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, LAND_ANIMATION);
            this.movement = EnumNagaMovement.FALLEN;
            this.onGroundTimer = GROUND_TIMER_MAX;
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            this.getNavigation().stop();
        }
        if (this.movement == EnumNagaMovement.FALLEN && this.onGroundTimer <= 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimationTick(0);
            AnimationHandler.INSTANCE.sendAnimationMessage(this, GET_UP_ANIMATION);
        }
        if (this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 43) {
            this.hoverAnim.increaseTimer();
            this.flapAnim.decreaseTimer();
        } else if (this.getAnimation() == HURT_TO_FALL_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == LAND_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() < 26) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.movement == EnumNagaMovement.FALLEN) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
            this.setYRot(this.yRotO);
            this.yHeadRot = this.yHeadRotO;
            this.setXRot(this.xRotO);
        } else if (this.movement == EnumNagaMovement.FALLING) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else {
            this.flapAnim.increaseTimer();
        }
        if (this.getAnimation() == SPIT_ANIMATION && this.level().isClientSide && this.mouthPos != null && !this.interrupted) {
            Vec3 particlePos;
            if (this.getAnimationTick() == 33) {
                float explodeSpeed = 2.4f;
                for (int i = 0; i < 25; ++i) {
                    particlePos = new Vec3(0.25, 0.0, 0.0);
                    particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                    double value = this.random.nextFloat() * 0.1f;
                    double life = this.random.nextFloat() * 10.0f + 20.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.level(), particlePos.x + this.mouthPos[0].x, particlePos.y + this.mouthPos[0].y, particlePos.z + this.mouthPos[0].z, particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                }
            }
            if (this.getAnimationTick() <= 15 && this.mouthPos != null && !this.interrupted) {
                int howMany = 4;
                for (int i = 0; i < howMany; ++i) {
                    particlePos = new Vec3(3.0, 0.0, 0.0);
                    particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                    double value = this.random.nextFloat() * 0.15f;
                    ParticleVanillaCloudExtended.spawnVanillaCloudDestination(this.level(), particlePos.x + this.mouthPos[0].x, particlePos.y + this.mouthPos[0].y, particlePos.z + this.mouthPos[0].z, 0.0, 0.0, 0.0, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.9, 15.0, this.mouthPos);
                }
            }
        }
        if (this.getAnimation() == HURT_TO_FALL_ANIMATION && this.getAnimationTick() == 17) {
            this.movement = EnumNagaMovement.FALLING;
        }
        if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() == 26) {
            this.movement = EnumNagaMovement.HOVERING;
        }
        if (this.level().isClientSide && this.movement == EnumNagaMovement.HOVERING && (double)this.flapAnim.getAnimationFraction() >= 0.5) {
            if ((double)this.shoulderRot > 0.9) {
                this.hasFlapSoundPlayed = false;
            }
            if ((double)this.shoulderRot <= 0.7 && !this.hasFlapSoundPlayed) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), SoundSource.HOSTILE, 2.0f, (float)(0.85 + (double)this.random.nextFloat() * 0.2), false);
                this.hasFlapSoundPlayed = true;
            }
        }
        this.hoverAnimFrac = this.hoverAnim.getAnimationProgressSinSqrt();
        this.flapAnimFrac = this.flapAnim.getAnimationProgressSinSqrt();
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        this.restrictTo(this.blockPosition(), MAX_DIST_FROM_HOME);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.COMMON.MOBS.NAGA.spawnConfig;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.NAGA.combatConfig;
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType reason) {
        boolean flag = super.checkSpawnRules(world, reason);
        this.setPos(this.getX(), this.getY() + 5.0, this.getZ());
        return flag && world.getDifficulty() != Difficulty.PEACEFUL;
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        boolean liquid = !this.level().containsAnyLiquid(this.getBoundingBox());
        boolean worldCollision = this.level().noCollision((Entity)this, this.getBoundingBox());
        boolean mobCollision = this.level().isUnobstructed((Entity)this);
        return liquid && worldCollision && mobCollision;
    }

    @Override
    protected void tickDeath() {
        super.tickDeath();
        if (this.deathTime == 15 && this.movement != EnumNagaMovement.FALLEN) {
            this.movement = EnumNagaMovement.FALLING;
        }
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        boolean isSwooping;
        boolean flag = super.hurt(source, damage);
        boolean isSpitting = this.getAnimation() == SPIT_ANIMATION && this.getAnimationTick() < 30;
        boolean bl = isSwooping = this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 25;
        if (flag && this.movement != EnumNagaMovement.FALLING && (isSpitting || isSwooping) && damage > 0.0f) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, HURT_TO_FALL_ANIMATION);
            this.interrupted = true;
        }
        return flag;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.interrupted) {
            return;
        }
        Vec3 projectilePos = new Vec3(1.0, -0.7, 0.0);
        projectilePos = projectilePos.yRot((float)Math.toRadians(-this.getYRot() - 90.0f));
        projectilePos = projectilePos.add(this.position());
        projectilePos = projectilePos.add(new Vec3(0.0, 0.0, 1.0).xRot((float)Math.toRadians(-this.getXRot())).yRot((float)Math.toRadians(-this.yHeadRot)));
        projectilePos = projectilePos.add(new Vec3(0.0, 0.0, 0.0));
        EntityPoisonBall poisonBall = new EntityPoisonBall((EntityType<? extends EntityPoisonBall>)((EntityType)EntityHandler.POISON_BALL.get()), this.level(), (LivingEntity)this);
        poisonBall.setPos(projectilePos.x, projectilePos.y, projectilePos.z);
        Vec3 look = this.getLookAngle();
        Vec3 dir = new Vec3(look.x, 0.0, look.z).normalize();
        if (target != null) {
            float dy = (float)(projectilePos.y - target.getY());
            float dx = (float)(projectilePos.x - target.getX());
            float dz = (float)(projectilePos.z - target.getZ());
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float timeGuess = (float)Math.sqrt(2.0f * dy / EntityPoisonBall.GRAVITY);
            float speed = Math.min(dist / timeGuess, 0.9f);
            poisonBall.shoot(dir.x * (double)speed, 0.1, dir.z * (double)speed, 1.0f, 0.0f);
        }
        this.level().addFreshEntity((Entity)poisonBall);
        this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT.get(), 2.0f, 1.0f);
        this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT_HISS.get(), 2.0f, 1.0f);
    }

    @Override
    public Animation getDeathAnimation() {
        if (this.movement == EnumNagaMovement.FALLEN) {
            return DIE_GROUND_ANIMATION;
        }
        return DIE_AIR_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{FLAP_ANIMATION, DODGE_ANIMATION, SWOOP_ANIMATION, SPIT_ANIMATION, HURT_TO_FALL_ANIMATION, LAND_ANIMATION, GET_UP_ANIMATION, DIE_AIR_ANIMATION, DIE_GROUND_ANIMATION, TAIL_DEMO_ANIMATION};
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        if (this.movement == EnumNagaMovement.FALLING) {
            return super.causeFallDamage(distance, damageMultiplier, source);
        }
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.movement == EnumNagaMovement.FALLING) {
            super.checkFallDamage(y, onGroundIn, state, pos);
        }
    }

    public void travel(@NotNull Vec3 motion) {
        boolean isFalling;
        double gravity = this.getGravity();
        boolean bl = isFalling = this.getDeltaMovement().y <= 0.0;
        if (isFalling && this.hasEffect(MobEffects.SLOW_FALLING)) {
            gravity = Math.max(gravity, 0.01);
        }
        FluidState fluidstate = this.level().getFluidState(this.blockPosition());
        if ((this.isInWater() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != NeoForgeMod.LAVA_TYPE.value()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
            if (this.isInWater() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, motion, gravity)) {
                double y = this.getY();
                float waterSpeed = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float swimSpeed = 0.02f;
                float speedModifier = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                if (!this.onGround()) {
                    speedModifier *= 0.5f;
                }
                if (speedModifier > 0.0f) {
                    waterSpeed += (0.54600006f - waterSpeed) * speedModifier;
                    swimSpeed += (this.getSpeed() - swimSpeed) * speedModifier;
                }
                if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    waterSpeed = 0.96f;
                }
                this.moveRelative(swimSpeed *= (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED), motion);
                this.move(MoverType.SELF, this.getDeltaMovement());
                Vec3 deltaMovement = this.getDeltaMovement();
                if (this.horizontalCollision && this.onClimbable()) {
                    deltaMovement = new Vec3(deltaMovement.x, 0.2, deltaMovement.z);
                }
                this.setDeltaMovement(deltaMovement.multiply((double)waterSpeed, (double)0.8f, (double)waterSpeed));
                Vec3 fluidMovement = this.getFluidFallingAdjustedMovement(gravity, isFalling, this.getDeltaMovement());
                this.setDeltaMovement(fluidMovement);
                if (this.horizontalCollision && this.isFree(fluidMovement.x, fluidMovement.y + (double)0.6f - this.getY() + y, fluidMovement.z)) {
                    this.setDeltaMovement(fluidMovement.x, 0.3f, fluidMovement.z);
                }
            }
        } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
            double y = this.getY();
            this.moveRelative(0.02f, motion);
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
                Vec3 fluidMovement = this.getFluidFallingAdjustedMovement(gravity, isFalling, this.getDeltaMovement());
                this.setDeltaMovement(fluidMovement);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            }
            if (gravity != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -gravity / 4.0, 0.0));
            }
            Vec3 deltaMovement = this.getDeltaMovement();
            if (this.horizontalCollision && this.isFree(deltaMovement.x, deltaMovement.y + (double)0.6f - this.getY() + y, deltaMovement.z)) {
                this.setDeltaMovement(deltaMovement.x, 0.3f, deltaMovement.z);
            }
        } else if (this.movement == EnumNagaMovement.HOVERING) {
            double dz;
            double dy;
            double dx;
            double distanceToDest;
            BlockPos ground = new BlockPos((int)this.getX(), (int)(this.getBoundingBox().minY - 1.0), (int)this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, motion);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
            BlockPos destination = this.getNavigation().getTargetPos();
            if (destination != null && (distanceToDest = Math.sqrt((dx = (double)destination.getX() - this.getX()) * dx + (dy = (double)destination.getY() - this.getY()) * dy + (dz = (double)destination.getZ() - this.getZ()) * dz)) < 0.1 && this.getAnimation() == NO_ANIMATION) {
                this.setDeltaMovement(0.0, 0.0, 0.0);
            }
        } else if (this.movement == EnumNagaMovement.GLIDING) {
            Vec3 vec3 = this.getDeltaMovement();
            if (vec3.y > -0.5) {
                this.fallDistance = 1.0f;
            }
            Vec3 moveDirection = this.getLookAngle();
            moveDirection = moveDirection.normalize();
            float f6 = this.getXRot() * ((float)Math.PI / 180);
            double d9 = Math.sqrt(moveDirection.x * moveDirection.x + moveDirection.z * moveDirection.z);
            double d11 = Math.sqrt(vec3.horizontalDistanceSqr());
            double d12 = moveDirection.length();
            float f3 = Mth.cos((float)f6);
            f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d12 / 0.4));
            vec3 = this.getDeltaMovement().add(0.0, gravity * (-1.0 + (double)f3 * 0.75), 0.0);
            if (vec3.y < 0.0 && d9 > 0.0) {
                double d3 = vec3.y * -0.1 * (double)f3;
                vec3 = vec3.add(moveDirection.x * d3 / d9, d3, moveDirection.z * d3 / d9);
            }
            if (f6 < 0.0f && d9 > 0.0) {
                double d13 = d11 * (double)(-Mth.sin((float)f6)) * 0.04;
                vec3 = vec3.add(-moveDirection.x * d13 / d9, d13 * 3.2, -moveDirection.z * d13 / d9);
            }
            if (d9 > 0.0) {
                vec3 = vec3.add((moveDirection.x / d9 * d11 - vec3.x) * 0.1, 0.0, (moveDirection.z / d9 * d11 - vec3.z) * 0.1);
            }
            this.setDeltaMovement(vec3.multiply((double)0.99f, (double)0.98f, (double)0.99f));
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (moveDirection.y() < 0.0 && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, FLAP_ANIMATION);
            }
        } else if (this.movement == EnumNagaMovement.FALLING || this.movement == EnumNagaMovement.FALLEN || this.isNoAi()) {
            BlockPos blockpos = this.getBlockPosBelowThatAffectsMyMovement();
            float f2 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getFriction((LevelReader)this.level(), this.getBlockPosBelowThatAffectsMyMovement(), (Entity)this);
            float f3 = this.onGround() ? f2 * 0.91f : 0.91f;
            Vec3 vec35 = this.handleRelativeFrictionAndCalculateMovement(motion, f2);
            double d2 = vec35.y;
            if (this.hasEffect(MobEffects.LEVITATION)) {
                d2 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec35.y) * 0.2;
            } else if (this.level().isClientSide && !this.level().hasChunkAt(blockpos)) {
                d2 = this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0;
            } else if (!this.isNoGravity()) {
                d2 -= gravity;
            }
            if (this.shouldDiscardFriction()) {
                this.setDeltaMovement(vec35.x, d2, vec35.z);
            } else {
                this.setDeltaMovement(vec35.x * (double)f3, d2 * (double)0.98f, vec35.z * (double)f3);
            }
        }
        this.calculateEntityAnimation(true);
    }

    public boolean onClimbable() {
        return false;
    }

    public boolean getAttacking() {
        return (Boolean)this.getEntityData().get(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.getEntityData().set(ATTACKING, (Object)attacking);
    }

    public float getBanking() {
        return ((Float)this.getEntityData().get(BANKING)).floatValue();
    }

    public void setBanking(float banking) {
        this.getEntityData().set(BANKING, (Object)Float.valueOf(banking));
    }

    public float getPrevBanking() {
        return ((Float)this.getEntityData().get(PREV_BANKING)).floatValue();
    }

    public void setPrevBanking(float prevBanking) {
        this.getEntityData().set(PREV_BANKING, (Object)Float.valueOf(prevBanking));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("HomePosX", this.getRestrictCenter().getX());
        compound.putInt("HomePosY", this.getRestrictCenter().getY());
        compound.putInt("HomePosZ", this.getRestrictCenter().getZ());
        compound.putInt("HomeDist", (int)this.getRestrictRadius());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        int i = compound.getInt("HomePosX");
        int j = compound.getInt("HomePosY");
        int k = compound.getInt("HomePosZ");
        int dist = compound.getInt("HomeDist");
        this.restrictTo(new BlockPos(i, j, k), dist);
    }

    @Override
    public int getDespawnDistance() {
        return 256;
    }

    @Override
    public int getNoDespawnDistance() {
        return 128;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LootTableHandler.NAGA;
    }

    public static enum EnumNagaMovement {
        GLIDING,
        HOVERING,
        SWIMMING,
        FALLING,
        FALLEN;

    }

    class NagaMoveHelper
    extends MoveControl {
        private final EntityNaga parentEntity;
        private int courseChangeCooldown;
        private float speedFactor;

        public NagaMoveHelper(EntityNaga naga) {
            super((Mob)naga);
            this.speedFactor = 0.1f;
            this.parentEntity = naga;
        }

        public void tick() {
            this.speedFactor = 1.0f;
            if (EntityNaga.this.movement == EnumNagaMovement.GLIDING) {
                if (this.operation == MoveControl.Operation.MOVE_TO) {
                    if (EntityNaga.this.horizontalCollision) {
                        EntityNaga naga = EntityNaga.this;
                        naga.setYRot(naga.getYRot() + 180.0f);
                        this.speedFactor = 0.1f;
                        EntityNaga.this.getNavigation().stop();
                    }
                    float orbitOffsetDiffX = (float)((double)EntityNaga.this.getNavigation().getTargetPos().getX() - EntityNaga.this.getX());
                    float orbitOffsetDiffY = (float)((double)EntityNaga.this.getNavigation().getTargetPos().getY() - EntityNaga.this.getY());
                    float orbitOffsetDiffZ = (float)((double)EntityNaga.this.getNavigation().getTargetPos().getZ() - EntityNaga.this.getZ());
                    double horizontalDistToOrbitOffset = Mth.sqrt((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ));
                    double yFractionReduction = 1.0 - (double)Mth.abs((float)(orbitOffsetDiffY * 0.7f)) / horizontalDistToOrbitOffset;
                    orbitOffsetDiffX = (float)((double)orbitOffsetDiffX * yFractionReduction);
                    orbitOffsetDiffZ = (float)((double)orbitOffsetDiffZ * yFractionReduction);
                    horizontalDistToOrbitOffset = Mth.sqrt((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ));
                    double distToOrbitOffset = Mth.sqrt((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ + orbitOffsetDiffY * orbitOffsetDiffY));
                    float rotationYaw = EntityNaga.this.getYRot();
                    float desiredRotationYaw = (float)Mth.atan2((double)orbitOffsetDiffZ, (double)orbitOffsetDiffX);
                    float rotationYawWrapped = Mth.wrapDegrees((float)(EntityNaga.this.getYRot() + 90.0f));
                    float desiredRotationYawWrapped = Mth.wrapDegrees((float)(desiredRotationYaw * 57.295776f));
                    EntityNaga.this.setYRot(Mth.approachDegrees((float)rotationYawWrapped, (float)desiredRotationYawWrapped, (float)4.0f) - 90.0f);
                    float newBanking = MowzieMathUtil.approachDegreesSmooth(EntityNaga.this.getBanking(), EntityNaga.this.getPrevBanking(), EntityNaga.this.getYRot() - rotationYaw, 0.5f, 0.1f);
                    EntityNaga.this.setPrevBanking(EntityNaga.this.getBanking());
                    EntityNaga.this.setBanking(newBanking);
                    EntityNaga.this.yBodyRot = EntityNaga.this.getYRot();
                    float desiredPitch = (float)(-(Mth.atan2((double)(-orbitOffsetDiffY), (double)horizontalDistToOrbitOffset) * 57.2957763671875));
                    EntityNaga.this.setXRot(Mth.approachDegrees((float)EntityNaga.this.getXRot(), (float)desiredPitch, (float)8.0f));
                    float rotationYaw1 = EntityNaga.this.getYRot() + 90.0f;
                    double xMotion = (double)(this.speedFactor * Mth.cos((float)(rotationYaw1 * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffX / distToOrbitOffset);
                    double yMotion = (double)(this.speedFactor * Mth.sin((float)(rotationYaw1 * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffZ / distToOrbitOffset);
                    double zMotion = (double)(this.speedFactor * Mth.sin((float)(desiredPitch * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffY / distToOrbitOffset);
                    Vec3 motion = EntityNaga.this.getDeltaMovement();
                    EntityNaga.this.setDeltaMovement(motion.add(new Vec3(xMotion, zMotion, yMotion).subtract(motion).scale(0.1)));
                }
            } else if (EntityNaga.this.movement == EnumNagaMovement.HOVERING && (EntityNaga.this.getAnimation() == IAnimatedEntity.NO_ANIMATION || EntityNaga.this.getAnimation() == SPIT_ANIMATION)) {
                LivingEntity target = EntityNaga.this.getTarget();
                if (target != null && EntityNaga.this.distanceToSqr((Entity)this.parentEntity) < 1600.0) {
                    EntityNaga.this.lookAt((Entity)target, 100.0f, 100.0f);
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.getRandom().nextInt(5) + 2;
                    Vec3 Vector3d2 = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                    double d0 = Vector3d2.length();
                    if (this.checkCollisions(Vector3d2 = Vector3d2.normalize(), Mth.ceil((double)d0))) {
                        this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(Vector3d2.scale(0.1)));
                    } else {
                        this.operation = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        public boolean checkCollisions(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    class NagaLookController
    extends LookControl {
        public NagaLookController(EntityNaga this$0, Mob entity) {
            super(entity);
        }

        public void tick() {
            if (this.lookAtCooldown > 0 && this.getYRotD().isPresent()) {
                --this.lookAtCooldown;
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, ((Float)this.getYRotD().get()).floatValue(), this.yMaxRotSpeed);
            } else {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, 10.0f);
            }
            if (!this.mob.getNavigation().isDone()) {
                this.mob.yHeadRot = Mth.rotateIfNecessary((float)this.mob.yHeadRot, (float)this.mob.yBodyRot, (float)this.mob.getMaxHeadYRot());
            }
        }
    }

    public class FlyOutOfWaterGoal
    extends Goal {
        private final EntityNaga entity;

        public FlyOutOfWaterGoal(EntityNaga this$0, EntityNaga entityIn) {
            this.entity = entityIn;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.entity.movement != EnumNagaMovement.FALLING && this.entity.movement != EnumNagaMovement.FALLEN && this.entity.isInWater() && this.entity.getFluidHeight(FluidTags.WATER) > this.entity.getFluidJumpThreshold() || this.entity.isInLava();
        }

        public void start() {
            if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, FLAP_ANIMATION);
            }
        }

        public boolean canContinueToUse() {
            return false;
        }
    }

    class WanderGoal
    extends Goal {
        private boolean seesGround;

        WanderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityNaga.this.navigation.isDone() && EntityNaga.this.getTarget() == null;
        }

        public boolean canContinueToUse() {
            return EntityNaga.this.navigation.isInProgress() && !EntityNaga.this.navigation.getTargetPos().closerThan((Vec3i)EntityNaga.this.blockPosition(), 4.0) && EntityNaga.this.getTarget() == null;
        }

        public void start() {
            Vec3 vector3d = this.getRandomLocation();
            if (vector3d != null) {
                EntityNaga.this.navigation.setMaxVisitedNodesMultiplier(0.5f);
                EntityNaga.this.navigation.moveTo(EntityNaga.this.navigation.createPath(BlockPos.containing((Position)vector3d), 1), 1.0);
            }
        }

        public void tick() {
            Vec3 newLocation;
            super.tick();
            if (!this.seesGround && (newLocation = this.getRandomLocation()) != null && this.seesGround) {
                EntityNaga.this.navigation.moveTo(EntityNaga.this.navigation.createPath(BlockPos.containing((Position)newLocation), 1), 1.0);
            }
        }

        public void stop() {
            super.stop();
            EntityNaga.this.getNavigation().stop();
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vector3d = EntityNaga.this.getViewVector(0.0f);
            Vec3 position = HoverRandomPos.getPos((PathfinderMob)EntityNaga.this, (int)24, (int)24, (double)vector3d.x, (double)vector3d.z, (float)1.5707964f, (int)18, (int)8);
            if (position == null) {
                Vec3 sumPos = EntityNaga.this.position().add(vector3d);
                position = AirAndWaterRandomPos.getPos((PathfinderMob)EntityNaga.this, (int)24, (int)8, (int)-8, (double)sumPos.x, (double)sumPos.z, (double)1.5707963705062866);
                this.seesGround = false;
            } else {
                this.seesGround = true;
            }
            if (position == null || !EntityNaga.this.level().isEmptyBlock(BlockPos.containing((Position)position).below())) {
                return null;
            }
            Vec3 offset = position.subtract(EntityNaga.this.position());
            AABB newBB = EntityNaga.this.getBoundingBox().move(offset);
            if (EntityNaga.this.level().noCollision(newBB) && EntityNaga.this.level().clip(new ClipContext(EntityNaga.this.position(), position, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)EntityNaga.this)).getType() != HitResult.Type.BLOCK) {
                return position;
            }
            return null;
        }
    }

    class AIFlyAroundTarget
    extends Goal {
        private final EntityNaga parentEntity;

        public AIFlyAroundTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.parentEntity.getTarget() != null && this.parentEntity.getNavigation().isDone()) {
                return this.parentEntity.random.nextInt(60) == 0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            double dz2;
            double dy2;
            double dz;
            double dy;
            if (EntityNaga.this.getTarget() == null) {
                return false;
            }
            BlockPos navigatorPos = this.parentEntity.getNavigation().getTargetPos();
            if (navigatorPos == null) {
                return false;
            }
            double dx = (double)navigatorPos.getX() - this.parentEntity.getX();
            double distanceToDest = Math.sqrt(dx * dx + (dy = (double)navigatorPos.getY() - this.parentEntity.getY()) * dy + (dz = (double)navigatorPos.getZ() - this.parentEntity.getZ()) * dz);
            if (distanceToDest > 60.0) {
                return false;
            }
            LivingEntity target = this.parentEntity.getTarget();
            double dx2 = (double)navigatorPos.getX() - target.getX();
            double distanceDestToTarget = Math.sqrt(dx2 * dx2 + (dy2 = (double)navigatorPos.getY() - target.getY()) * dy2 + (dz2 = (double)navigatorPos.getZ() - target.getZ()) * dz2);
            if (distanceDestToTarget > 20.0 || distanceDestToTarget < 5.0) {
                return false;
            }
            return EntityNaga.this.navigation.isInProgress() && !EntityNaga.this.navigation.getTargetPos().closerThan((Vec3i)EntityNaga.this.blockPosition(), 1.0);
        }

        public void start() {
            RandomSource random = this.parentEntity.getRandom();
            LivingEntity target = this.parentEntity.getTarget();
            float yaw = (float)((double)random.nextFloat() * Math.PI * 2.0);
            float radius = 16.0f;
            double d0 = target.getX() + Math.cos(yaw) * (double)radius;
            double d1 = target.getY() + 8.0 + (double)(random.nextFloat() * 5.0f);
            double d2 = target.getZ() + Math.sin(yaw) * (double)radius;
            double speed = this.parentEntity.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
            if (!this.parentEntity.level().isWaterAt(BlockPos.containing((double)d0, (double)d1, (double)d2))) {
                this.parentEntity.getNavigation().moveTo(d0, d1, d2, speed);
            }
        }

        public void stop() {
            super.stop();
            EntityNaga.this.getNavigation().stop();
        }
    }

    class AIFlyTowardsTarget
    extends Goal {
        private final EntityNaga parentEntity;

        public AIFlyTowardsTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.parentEntity.getTarget() != null && EntityNaga.this.distanceToSqr((Entity)this.parentEntity.getTarget()) >= 870.25;
        }

        public boolean canContinueToUse() {
            double dz;
            double dy;
            if (EntityNaga.this.getTarget() == null) {
                return false;
            }
            if (EntityNaga.this.getTarget().distanceToSqr((Entity)this.parentEntity) <= 500.0) {
                return false;
            }
            BlockPos navigatorPos = this.parentEntity.getNavigation().getTargetPos();
            if (navigatorPos == null) {
                return false;
            }
            double dx = (double)navigatorPos.getX() - this.parentEntity.getX();
            double distanceToDest = Math.sqrt(dx * dx + (dy = (double)navigatorPos.getY() - this.parentEntity.getY()) * dy + (dz = (double)navigatorPos.getZ() - this.parentEntity.getZ()) * dz);
            if (distanceToDest > 60.0) {
                return false;
            }
            return EntityNaga.this.navigation.isInProgress();
        }

        public void tick() {
            super.tick();
            LivingEntity target = this.parentEntity.getTarget();
            double speed = this.parentEntity.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
            BlockPos targetPos = target.blockPosition().above(8);
            if (!this.parentEntity.level().isWaterAt(targetPos)) {
                this.parentEntity.getNavigation().moveTo((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), speed);
            }
        }

        public void stop() {
            super.stop();
            EntityNaga.this.getNavigation().stop();
        }
    }

    static class AILookAround
    extends Goal {
        private final EntityNaga parentEntity;

        public AILookAround(EntityNaga naga) {
            this.parentEntity = naga;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            if (this.parentEntity.getTarget() == null) {
                Vec3 motion = this.parentEntity.getDeltaMovement();
                this.parentEntity.setYRot(-((float)Mth.atan2((double)motion.x, (double)motion.z)) * 57.295776f);
                this.parentEntity.yBodyRot = this.parentEntity.getYRot();
            } else {
                LivingEntity entitylivingbase = this.parentEntity.getTarget();
                if (entitylivingbase.distanceToSqr((Entity)this.parentEntity) < 1600.0) {
                    double d1 = entitylivingbase.getX() - this.parentEntity.getX();
                    double d2 = entitylivingbase.getZ() - this.parentEntity.getZ();
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                }
            }
        }
    }
}

