/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.GeckoDynamicChain;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class MowzieGeckoEntity
extends MowzieEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected MowzieAnimationController<MowzieGeckoEntity> controller = new MowzieAnimationController<MowzieGeckoEntity>(this, "controller", 5, this::predicate, 0.0);
    public GeckoDynamicChain[] dynamicChains;
    private static RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");

    public MowzieGeckoEntity(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected int getDeathDuration() {
        Ability<?> deathAbility = this.getActiveAbility();
        if (deathAbility instanceof SimpleAnimationAbility) {
            return ((SimpleAnimationAbility)deathAbility).getDuration();
        }
        return 20;
    }

    @Override
    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
    }

    public abstract AbilityType getHurtAbility();

    public abstract AbilityType getDeathAbility();

    public boolean shouldPlayHurtAnimation(DamageSource source, float damage) {
        return this.playsHurtAnimation;
    }

    public boolean hurt(DamageSource source, float damage) {
        boolean attack = super.hurt(source, damage);
        if (attack) {
            if (this.getHealth() > 0.0f && (this.getActiveAbility() == null || this.getActiveAbility().damageInterrupts()) && this.shouldPlayHurtAnimation(source, damage)) {
                this.sendAbilityMessage(this.getHurtAbility());
            } else if (this.getHealth() <= 0.0f) {
                this.sendAbilityMessage(this.getDeathAbility());
            }
        }
        return attack;
    }

    protected <E extends GeoEntity> PlayState predicate(AnimationState<E> state) {
        AbilityData abilityData = this.getAbilityData();
        if (abilityData == null) {
            return PlayState.STOP;
        }
        if (DataHandler.getData((Entity)this, DataHandler.FROZEN_DATA).getFrozen()) {
            return PlayState.STOP;
        }
        if (abilityData.getActiveAbility() != null) {
            this.getController().transitionLength(0);
            return abilityData.animationPredicate(state, null);
        }
        this.loopingAnimations(state);
        return PlayState.CONTINUE;
    }

    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        event.getController().setAnimation(IDLE_ANIM);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.controller);
    }

    public MowzieAnimationController<MowzieGeckoEntity> getController() {
        return this.controller;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[0];
    }

    public AbilityData getAbilityData() {
        return DataHandler.getData((Entity)this, DataHandler.ABILITY_DATA);
    }

    public Ability<?> getActiveAbility() {
        AbilityData data = this.getAbilityData();
        if (data == null) {
            return null;
        }
        return this.getAbilityData().getActiveAbility();
    }

    public AbilityType getActiveAbilityType() {
        Ability<?> ability = this.getActiveAbility();
        if (ability == null) {
            return null;
        }
        return ability.getAbilityType();
    }

    public Ability<?> getAbility(AbilityType abilityType) {
        AbilityData data = this.getAbilityData();
        if (data == null) {
            return null;
        }
        return this.getAbilityData().getAbilityMap().get(abilityType);
    }

    public void sendAbilityMessage(AbilityType abilityType) {
        AbilityHandler.INSTANCE.sendAbilityMessage(this, abilityType);
    }
}

