/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.gui;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade.Trade;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerUmvuthanaTrade;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public final class GuiUmvuthanaTrade
extends AbstractContainerScreen<ContainerUmvuthanaTrade> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/gui/container/umvuthana.png");
    private final EntityUmvuthanaMinion umvuthana;

    public GuiUmvuthanaTrade(ContainerUmvuthanaTrade screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.umvuthana = screenContainer.getUmvuthana();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        return super.mouseReleased(mouseX, mouseY, state);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.umvuthana.renderingInGUI = true;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 8), (int)(this.topPos + 8), (int)(this.leftPos + 59), (int)(this.topPos + 69), (int)20, (float)0.25f, (float)x, (float)y, (LivingEntity)this.umvuthana);
        this.umvuthana.renderingInGUI = false;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        String title = I18n.get((String)"entity.mowziesmobs.umvuthana.trade", (Object[])new Object[0]);
        guiGraphics.drawString(this.font, title, (int)((float)this.imageWidth / 2.0f - (float)this.font.width(title) / 2.0f + 26.0f), 6, 0x404040, false);
        guiGraphics.drawString(this.font, I18n.get((String)"container.inventory", (Object[])new Object[0]), 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.umvuthana.isOfferingTrade()) {
            Trade trade = this.umvuthana.getOfferingTrade();
            ItemStack input = trade.getInput();
            ItemStack output = trade.getOutput();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.renderItem(input, this.leftPos + 80, this.topPos + 24);
            guiGraphics.renderItemDecorations(this.font, input, this.leftPos + 80, this.topPos + 24);
            guiGraphics.renderItem(output, this.leftPos + 134, this.topPos + 24);
            guiGraphics.renderItemDecorations(this.font, output, this.leftPos + 134, this.topPos + 24);
            if (this.isHovering(80, 24, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, input, mouseX, mouseY);
            } else if (this.isHovering(134, 24, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, output, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
        }
    }
}

