/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IItemActionPayloadBuilder;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.network.DepositItemsPayload;
import net.p3pp3rf1y.sophisticatedcore.network.RestockItemsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class ItemInteractionHandler {
    public static final int INTERACTION_RANGE = 10;
    private static List<IItemActionPayloadBuilder<?>> payloadBuilders = new ArrayList();

    public static void registerPayloadBuilder(IItemActionPayloadBuilder<?> payloadBuilder) {
        payloadBuilders.add(payloadBuilder);
    }

    public static void depositMultipleItems(Player player, boolean mainInventory, boolean hotbar, boolean onlyMatching) {
        if (!mainInventory && !hotbar) {
            throw new IllegalArgumentException("At least one of mainInventory or hotbar must be true");
        }
        int minSlot = hotbar ? 0 : 9;
        int maxSlot = mainInventory ? 36 : 9;
        ItemInteractionHandler.depositItem(player, minSlot, maxSlot, onlyMatching);
    }

    public static void depositItem(Player player, int itemSlot, boolean onlyMatching) {
        ItemInteractionHandler.depositItem(player, itemSlot, itemSlot + 1, onlyMatching);
    }

    private static void depositItem(Player player, int minSlot, int maxSlot, boolean onlyMatching) {
        HashSet storages = new HashSet();
        HashSet controllers = new HashSet();
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, IControllableStorage.class).forEach(s -> s.getControllerPos().ifPresentOrElse(pos -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, controllers, pos), () -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, storages, s.getStorageBlockPos())));
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, ControllerBlockEntityBase.class).forEach(c -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, controllers, c.getBlockPos()));
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>();
        payloadBuilders.forEach(h -> h.buildClientRequestData(player).ifPresent(data -> extras.put(h.getPayloadHandlerId(), data)));
        if (!(storages.isEmpty() && controllers.isEmpty() && extras.isEmpty())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DepositItemsPayload(minSlot, maxSlot, new ArrayList<BlockPos>(storages), new ArrayList<BlockPos>(controllers), extras, onlyMatching), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ItemInteractionHandler.playError(player, TranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
        }
    }

    private static void addIfPlayerCanInteractWith(Player player, Set<BlockPos> positions, BlockPos pos) {
        if (player.mayInteract(player.level(), pos)) {
            positions.add(pos);
        }
    }

    public static void restockMultipleItems(Player player, ItemStack filter, boolean mainInventory, boolean hotbar, boolean fillEmpty) {
        if (!mainInventory && !hotbar) {
            throw new IllegalArgumentException("At least one of mainInventory or hotbar must be true");
        }
        int minSlot = hotbar ? 0 : 9;
        int maxSlot = mainInventory ? 36 : 9;
        ItemInteractionHandler.restockItem(player, filter, minSlot, maxSlot, fillEmpty);
    }

    public static void restockItem(Player player, ItemStack filter, int itemSlot, boolean fillEmpty) {
        ItemStack item = player.getInventory().getItem(itemSlot);
        if (!fillEmpty && item.getCount() == item.getMaxStackSize()) {
            ItemInteractionHandler.playError(player, TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_full_stack", item.getHoverName().copy().setStyle(Style.EMPTY.withColor(0xFF5555))));
            return;
        }
        ItemInteractionHandler.restockItem(player, filter, itemSlot, itemSlot + 1, fillEmpty);
    }

    private static void restockItem(Player player, ItemStack filter, int minSlot, int maxSlot, boolean fillEmpty) {
        if (maxSlot - minSlot > 1 && ItemInteractionHandler.checkStacksDoNotAllowRestock(player, minSlot, maxSlot, fillEmpty)) {
            ItemInteractionHandler.playError(player, TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_full_stacks", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
            return;
        }
        HashSet storages = new HashSet();
        HashSet visitedControllers = new HashSet();
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, ControllerBlockEntityBase.class).forEach(c -> {
            visitedControllers.add(c.getBlockPos());
            c.getStoragePositions().forEach(pos -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, storages, pos));
        });
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, IControllableStorage.class).forEach(s -> s.getControllerPos().ifPresentOrElse(controllerPos -> {
            if (!visitedControllers.contains(controllerPos)) {
                visitedControllers.add(controllerPos);
                List<BlockPos> storagePositions = WorldHelper.getBlockEntity((BlockGetter)player.level(), controllerPos, ControllerBlockEntityBase.class).map(ControllerBlockEntityBase::getStoragePositions).orElse(Collections.emptyList());
                storagePositions.forEach(pos -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, storages, pos));
            }
        }, () -> ItemInteractionHandler.addIfPlayerCanInteractWith(player, storages, s.getStorageBlockPos())));
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>();
        payloadBuilders.forEach(h -> h.buildClientRequestData(player).ifPresent(data -> extras.put(h.getPayloadHandlerId(), data)));
        if (!storages.isEmpty() || !extras.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RestockItemsPayload(filter, minSlot, maxSlot, fillEmpty, new ArrayList<BlockPos>(storages), extras), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ItemInteractionHandler.playError(player, TranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
        }
    }

    private static boolean checkStacksDoNotAllowRestock(Player player, int minSlot, int maxSlot, boolean fillEmpty) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if ((!fillEmpty || !stack.isEmpty()) && (stack.isEmpty() || stack.getCount() >= stack.getMaxStackSize())) continue;
            return false;
        }
        return true;
    }

    private static void playError(Player player, MutableComponent message) {
        player.displayClientMessage((Component)message, true);
        player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 0.45f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.1f);
    }
}

